/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.util.statistics;

import com.google.common.collect.Maps;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.IOException;
import java.net.URL;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import net.minecraft.launcher.Http;
import org.tlauncher.statistics.UniqueClientDTO;
import org.tlauncher.statistics.UpdaterDTO;
import org.tlauncher.tlauncher.configuration.Configuration;
import org.tlauncher.tlauncher.controller.UpdaterFormController;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.updater.client.Update;
import org.tlauncher.util.OS;
import org.tlauncher.util.U;
import org.tlauncher.util.async.AsyncThread;

public class StatisticsUtil {
    public static void startSending(String path, Object ob, Map<String, Object> queries) {
        if (!TLauncher.getInstance().getConfiguration().getBoolean("gui.statistics.checkbox")) {
            AsyncThread.execute(() -> {
                try {
                    StatisticsUtil.send(path, ob, queries);
                }
                catch (IOException e) {
                    U.log(e);
                }
            });
        }
    }

    public static void send(String path, Object ob, Map<String, Object> queries) throws IOException {
        String domain = TLauncher.getInnerSettings().get("statistics.url");
        Http.performPost(new URL(Http.get(domain + path, queries)), TLauncher.getGson().toJson(ob), "application/json");
    }

    public static void sendMachineInfo(Configuration conf) {
        UniqueClientDTO running = new UniqueClientDTO();
        running.setClientVersion(TLauncher.getVersion());
        running.setOs(OS.CURRENT.name());
        Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
        running.setResolution(size.width + "x" + size.height);
        running.setJavaVersion(System.getProperty("java.version"));
        running.setOsVersion(OS.VERSION);
        running.setUuid(conf.get("client").replace("-", ""));
        running.setGpu(conf.get("gpu.info"));
        running.setRam(OS.Arch.TOTAL_RAM_MB);
        running.setProcessorArchitecture(conf.get("processor.architecture"));
        running.setBits(OS.getJavaBit().name());
        String processor = conf.get("process.info");
        if (Objects.nonNull(processor)) {
            processor = processor.trim();
        }
        running.setCpu(processor);
        StatisticsUtil.startSending("save/run/tlauncher/unique/month", running, Maps.newHashMap());
    }

    public static void sendUpdatingInfo(Update update, UpdaterFormController.UserResult res) {
        try {
            UpdaterDTO dto = StatisticsUtil.preparedUpdaterDTO(update, res);
            StatisticsUtil.send("updater/save", dto, Maps.newHashMap());
        }
        catch (Throwable t) {
            U.log(t);
        }
    }

    public static UpdaterDTO preparedUpdaterDTO(Update update, UpdaterFormController.UserResult res) {
        UpdaterDTO dto = new UpdaterDTO();
        dto.setClient(TLauncher.getInstance().getConfiguration().get("client"));
        dto.setOffer(update.getSelectedOffer().getOffer());
        dto.setArgs(res.getOfferArgs());
        dto.setCurrentVersion(TLauncher.getInnerSettings().getDouble("version"));
        dto.setNewVersion(update.getVersion());
        dto.setRequestTime(new Date().toString());
        return dto;
    }
}

