/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.util;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.cert.X509Certificate;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.X509TrustManager;
import net.minecraft.launcher.Http;
import net.minecraft.launcher.versions.CompleteVersion;
import net.minecraft.launcher.versions.ModifiedVersion;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.http.client.methods.HttpRequestBase;
import org.tlauncher.tlauncher.configuration.Configuration;
import org.tlauncher.tlauncher.configuration.InnerConfiguration;
import org.tlauncher.tlauncher.configuration.LangConfiguration;
import org.tlauncher.tlauncher.downloader.Downloadable;
import org.tlauncher.tlauncher.exceptions.RequiredTLAccountException;
import org.tlauncher.tlauncher.exceptions.SelectedAnyOneTLAccountException;
import org.tlauncher.tlauncher.minecraft.auth.Account;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.alert.Alert;
import org.tlauncher.tlauncher.ui.loc.Localizable;
import org.tlauncher.tlauncher.ui.log.LogFrame;
import org.tlauncher.tlauncher.updater.bootstrapper.model.JavaConfig;
import org.tlauncher.tlauncher.updater.bootstrapper.model.JavaDownloadedElement;
import org.tlauncher.util.FileUtil;
import org.tlauncher.util.MinecraftUtil;
import org.tlauncher.util.OS;
import org.tlauncher.util.U;
import org.tlauncher.util.async.AsyncThread;

public class TlauncherUtil {
    public static final String PROTECTED_DOUBLE_RUNNING_FILE = "doubleRunningProtection.txt";
    private static final int CAN_RUNNING_AFTER = 1;
    public static final String LOG_CHARSET = TlauncherUtil.defineCharsetString("cp1251");
    public static final String TLAUNCHER_ADDITIONAL_CONFIG = "TLauncherAdditional";
    private static volatile long time = 0L;

    public static void sendLog(Throwable e) {
        if (TLauncher.DEBUG) {
            return;
        }
        if (Localizable.get() == null) {
            try {
                Configuration settings = Configuration.createConfiguration();
                Locale locale = settings.getLocale();
                InnerConfiguration innerConfig = new InnerConfiguration(FileUtil.getResourceAppStream("/inner.tlauncher.properties"));
                Localizable.setLang(new LangConfiguration(settings.getLocales(), locale, innerConfig.get("tlauncher.language.folder")));
            }
            catch (IOException e1) {
                e1.addSuppressed(e);
                e = e1;
                e1.printStackTrace();
            }
        }
        new LogFrame(TLauncher.getInstance().getFrame(), e).setVisible(true);
    }

    public static void sendLog(String type) {
        if (TLauncher.DEBUG) {
            return;
        }
        if (time + 120000L > System.currentTimeMillis()) {
            return;
        }
        time = System.currentTimeMillis();
        try {
            HashMap query = Maps.newHashMap();
            query.put("version", TLauncher.getVersion());
            query.put("clientType", type);
            URL url = Http.constantURL(Http.get(TLauncher.getInnerSettings().get("log.system"), query));
            Http.performPost(url, U.readFileLog().getBytes(LOG_CHARSET), "text/plain", true);
        }
        catch (Throwable ex) {
            StringWriter stringWriter = new StringWriter();
            ex.printStackTrace(new PrintWriter(stringWriter));
            U.log(stringWriter.toString());
        }
    }

    public static void checkRedirect() {
    }

    public static int hostAvailabilityCheck(String host) {
        if (host.endsWith("/")) {
            host = host.substring(0, host.length() - 1);
        }
        try {
            URL url = new URL(host);
            HttpURLConnection httpConn = Downloadable.setUp(url.openConnection(), true);
            httpConn.setRequestMethod("HEAD");
            httpConn.setInstanceFollowRedirects(true);
            httpConn.connect();
            U.debug(host + " : " + httpConn.getResponseCode());
            return httpConn.getResponseCode();
        }
        catch (Throwable e) {
            U.debug(host + " is down ");
            return 500;
        }
    }

    public static void testNet() {
        try {
            Http.performGet("https://tlauncher.org/repo/update/lch/additional_hot_servers.json");
            Http.performGet("https://dl2.fastrepo.org/not_remove_test_file.txt");
            TlauncherUtil.testNet1();
        }
        catch (Throwable e) {
            if (e instanceof SSLHandshakeException) {
                Alert.showLocWarning("", "block.doctor.web", null);
            } else {
                TlauncherUtil.testNet1();
            }
            U.log("error", e);
        }
    }

    private static void testNet1() {
        int code = TlauncherUtil.hostAvailabilityCheck("http://page.tlauncher.org");
        if (code == 503 || code == 403) {
            Alert.showErrorHtml("", "alert.block.ip");
        }
    }

    public static void deactivateSSL() {
        Configuration c = TLauncher.getInstance().getConfiguration();
        if (c.get("ssl.deactivate.date") == null || LocalDate.parse(c.get("ssl.deactivate.date")).isBefore(LocalDate.now())) {
            TLauncher.getInstance().getConfiguration().set("ssl.deactivate.date", (Object)LocalDate.now().plusMonths(1L));
            try {
                TLauncher.getInstance().getConfiguration().save();
            }
            catch (IOException e1) {
                U.log(e1);
            }
        }
        try {
            SSLContext context = SSLContext.getInstance("SSL");
            context.init(null, new X509TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }}, null);
            HttpsURLConnection.setDefaultSSLSocketFactory(context.getSocketFactory());
        }
        catch (Throwable var1) {
            U.log(var1);
        }
        HttpsURLConnection.setDefaultHostnameVerifier((s, sslSession) -> true);
    }

    public static void checkServersAvalability(String[] array) {
        List<CompletableFuture> servers = Arrays.stream(array).map(link -> CompletableFuture.supplyAsync(() -> {
            if (TlauncherUtil.hostAvailabilityCheck(link) == 503) {
                U.log("     server code 503 -> " + link);
                return 503;
            }
            return 200;
        }, AsyncThread.getService())).collect(Collectors.toList());
        try {
            CompletableFuture.allOf(servers.toArray(new CompletableFuture[0])).get();
            if (servers.stream().allMatch(e -> {
                try {
                    return ((Integer)e.get()).equals(200);
                }
                catch (Exception exception) {
                    return false;
                }
            })) {
                U.log("#####    all servers are available   ######");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static int checkDoubleRunning() {
        File f = MinecraftUtil.getTLauncherFile(PROTECTED_DOUBLE_RUNNING_FILE);
        if (Files.exists(f.toPath(), new LinkOption[0])) {
            try {
                Date start = new Date(Long.parseLong(FileUtil.readFile(f)));
                Date end = new Date(start.getTime() + TimeUnit.MINUTES.toMillis(1L));
                Date current = new Date();
                if (current.after(start) && current.before(end)) {
                    return (int)(TimeUnit.MINUTES.toSeconds(1L) - (current.getTime() - start.getTime()) / 1000L);
                }
            }
            catch (Throwable e) {
                U.log(e);
            }
        }
        return 0;
    }

    public static String resolveHostName(String path) throws MalformedURLException, UnknownHostException {
        URL url = new URL(path);
        return url.getProtocol() + "://" + InetAddress.getByName(url.getHost()).getHostAddress() + ":" + url.getPort() + url.getFile();
    }

    public static boolean isAdmin() {
        if (!OS.is(OS.WINDOWS)) {
            return true;
        }
        try {
            String[] groups;
            Class<?> cl = Class.forName("com.sun.security.auth.module.NTSystem");
            if (Objects.isNull(cl)) {
                return true;
            }
            Method method = cl.getMethod("getGroupIDs", new Class[0]);
            for (String group : groups = (String[])method.invoke(cl.newInstance(), new Object[0])) {
                if (!group.equals("S-1-5-32-544")) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            U.log(e);
            return true;
        }
    }

    public static String getPageLanguage() {
        if (Objects.nonNull(TLauncher.getInstance()) && Objects.nonNull(TLauncher.getInstance().getConfiguration()) && TLauncher.getInstance().getConfiguration().isUSSRLocale()) {
            return "ru";
        }
        return "en";
    }

    public static String findJavaOptionAndGetName() {
        for (Map.Entry<String, String> e : System.getenv().entrySet()) {
            if (!e.getKey().equalsIgnoreCase("_java_options")) continue;
            return e.getKey();
        }
        return null;
    }

    public static String getStringError(Throwable e) {
        StringWriter stringWriter = new StringWriter();
        e.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString().replaceAll(System.lineSeparator(), "<br>");
    }

    public static File getJVMFolder(JavaConfig config, File tlauncherFolder) {
        JavaDownloadedElement java = TlauncherUtil.getProperJavaElement(config);
        return new File(new File(tlauncherFolder, "jvms"), java.getJavaFolder());
    }

    public static JavaDownloadedElement getProperJavaElement(JavaConfig config) {
        if (TlauncherUtil.useX64JavaInsteadX32Java()) {
            return config.getConfig().get((Object)OS.CURRENT).get((Object)OS.Arch.x64);
        }
        return config.getConfig().get((Object)OS.CURRENT).get((Object)OS.Arch.CURRENT);
    }

    public static boolean useX64JavaInsteadX32Java() {
        if (OS.is(OS.WINDOWS) && OS.Arch.CURRENT.equals((Object)OS.Arch.x32)) {
            String s = OS.executeByTerminal("wmic os get osarchitecture");
            return s.contains("64");
        }
        return false;
    }

    public static void showCriticalProblem(String message) {
        Alert.showErrorHtml("A critical error has occurred, ask for help <br> <a href='https://vk.me/tlauncher'> https://vk.me/tlauncher </a> or by mail <b> support@tlauncher.org </b><br><br>" + message, 500);
    }

    public static void showCriticalProblem(Throwable e) {
        TlauncherUtil.showCriticalProblem(TlauncherUtil.getStringError(e));
        TLauncher.kill();
    }

    public static boolean hasCorrectJavaFX() {
        try {
            Class.forName("javafx.embed.swing.JFXPanel");
        }
        catch (Throwable e) {
            return false;
        }
        return true;
    }

    public static void fillGPUInfo(Configuration con, boolean wait) {
        try {
            String res;
            List names;
            if (OS.is(OS.WINDOWS)) {
                Path dxdiag = Paths.get(MinecraftUtil.getWorkingDirectory().getAbsolutePath(), "logs", "tlauncher", "dxdiag.txt");
                boolean dxdiagExist = Files.exists(dxdiag, new LinkOption[0]);
                if (!dxdiagExist || FileUtils.isFileOlder(dxdiag.toFile(), DateUtils.addDays((Date)new Date(), (int)-10))) {
                    String command = String.format("dxdiag /whql:off /t %s", dxdiag.toString());
                    OS.executeByTerminal(command);
                }
                AsyncThread.execute(() -> {
                    if (wait) {
                        U.sleepFor(15000L);
                    }
                    if (Files.exists(dxdiag, new LinkOption[0])) {
                        try {
                            String gpu;
                            List names;
                            String file = FileUtil.readFile(dxdiag.toFile(), Charset.defaultCharset().name());
                            String[] params = file.split(System.lineSeparator());
                            String name = Arrays.stream(params).filter(e -> (e = e.toLowerCase()).contains("card name:") || e.contains("chip type:") || e.contains("display memory:")).map(s -> s.split(":")[1]).collect(Collectors.joining(","));
                            if (StringUtils.isNotBlank((CharSequence)name)) {
                                con.set("gpu.info.full", (Object)name);
                            }
                            if (!(names = Arrays.stream(params).filter(e -> {
                                e = e.toLowerCase();
                                return e.contains("card name:");
                            }).map(s -> s.split(":")[1]).collect(Collectors.toList())).isEmpty() && !(gpu = ((String)names.get(names.size() - 1)).trim()).equalsIgnoreCase("Intel(R) HD Graphics")) {
                                con.set("gpu.info", (Object)gpu);
                            }
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                });
            } else if (OS.is(OS.LINUX)) {
                String res2 = OS.executeByTerminal("lshw -C display");
                String[] params = res2.split(System.lineSeparator());
                List names2 = Arrays.stream(params).filter(e -> e.contains("product:")).map(s -> s.split(":")[1]).collect(Collectors.toList());
                if (!names2.isEmpty()) {
                    con.set("gpu.info", (Object)((String)names2.get(names2.size() - 1)).trim());
                    con.set("gpu.info.full", (Object)((String)names2.get(names2.size() - 1)).trim());
                }
            } else if (OS.is(OS.OSX) && !(names = Arrays.stream((res = OS.executeByTerminal("system_profiler SPDisplaysDataType")).split(System.lineSeparator())).filter(e -> e.toLowerCase().contains("chipset model:")).map(s -> s.split(":")[1]).collect(Collectors.toList())).isEmpty()) {
                con.set("gpu.info", (Object)((String)names.get(names.size() - 1)).trim());
                con.set("gpu.info.full", (Object)((String)names.get(names.size() - 1)).trim());
            }
        }
        catch (Throwable e2) {
            U.log(e2);
        }
    }

    public static String defineCharsetString(String charset) {
        if (Charset.isSupported(charset)) {
            return charset;
        }
        return Charset.defaultCharset().name();
    }

    public static void createTimeStart() {
        try {
            File file = MinecraftUtil.getTLauncherFile(PROTECTED_DOUBLE_RUNNING_FILE);
            FileUtil.writeFile(file, "" + new Date().getTime());
        }
        catch (Throwable e) {
            U.log("can't delete file", e);
        }
    }

    public static void clearTimeLabel() {
        U.log("[Double running]", "clear time label");
        try {
            FileUtil.deleteFile(MinecraftUtil.getTLauncherFile(PROTECTED_DOUBLE_RUNNING_FILE));
        }
        catch (Throwable e) {
            U.log("can't delete file", e);
        }
    }

    public static void processRemoteVersionToSave(CompleteVersion complete, String remoteVersion, Gson gson) {
        ModifiedVersion modifiedVersion = complete.getModifiedVersion();
        if (Objects.isNull(complete.getInheritsFrom()) && TlauncherUtil.notHasAnyAdditionalTLauncherField(modifiedVersion)) {
            modifiedVersion.setRemoteVersion(remoteVersion);
        }
    }

    public static boolean notHasAnyAdditionalTLauncherField(ModifiedVersion modifiedVersion) {
        return modifiedVersion.getJar() == null && modifiedVersion.getModpack() == null && modifiedVersion.getModsLibraries() == null && modifiedVersion.getAdditionalFiles() == null;
    }

    public static void addAuthHeaders(HttpRequestBase http) throws RequiredTLAccountException, SelectedAnyOneTLAccountException {
        TLauncher tl = TLauncher.getInstance();
        Account ac = tl.getProfileManager().findUniqueTlauncherAccount();
        http.addHeader("uuid", tl.getProfileManager().getClientToken().toString());
        http.addHeader("accessToken", ac.getAccessToken());
    }

    public static String getPage() {
        Locale loc = TLauncher.getInstance().getConfiguration().getLocale();
        return TLauncher.getInstance().getPagePrafix() + String.format("index_%s.html", loc.getCountry().isEmpty() ? loc.getLanguage() : loc.getLanguage() + "_" + loc.getCountry());
    }
}

