/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.util;

import com.github.junrar.Archive;
import com.github.junrar.extract.ExtractArchive;
import com.github.junrar.rarfile.FileHeader;
import com.google.common.collect.Lists;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.tlauncher.exceptions.ParseModPackException;
import org.tlauncher.modpack.domain.client.GameEntityDTO;
import org.tlauncher.modpack.domain.client.MapDTO;
import org.tlauncher.modpack.domain.client.ModDTO;
import org.tlauncher.modpack.domain.client.ResourcePackDTO;
import org.tlauncher.modpack.domain.client.ShaderpackDTO;
import org.tlauncher.modpack.domain.client.share.GameType;
import org.tlauncher.modpack.domain.client.version.MapMetadataDTO;
import org.tlauncher.modpack.domain.client.version.MetadataDTO;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.util.MinecraftUtil;
import org.tlauncher.util.U;

public class FileUtil {
    public static final String DEFAULT_CHARSET = "UTF-8";
    public static final String NAME_ARCHIVE = "logOfFiles.zip";
    public static final Long SIZE_100 = 0x6400000L;
    public static final Long SIZE_200 = 0xC800000L;
    public static final Long SIZE_300 = 314572800L;
    public static Set<PosixFilePermission> PERMISSIONS = new HashSet<PosixFilePermission>(){
        {
            this.add(PosixFilePermission.OWNER_READ);
            this.add(PosixFilePermission.OWNER_WRITE);
            this.add(PosixFilePermission.OWNER_EXECUTE);
            this.add(PosixFilePermission.OTHERS_READ);
            this.add(PosixFilePermission.OTHERS_EXECUTE);
            this.add(PosixFilePermission.GROUP_READ);
            this.add(PosixFilePermission.GROUP_EXECUTE);
        }
    };

    public static Charset getCharset() {
        try {
            return Charset.forName(DEFAULT_CHARSET);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void writeFile(File file, String text) throws IOException {
        FileUtil.createFile(file);
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));
        OutputStreamWriter ow = new OutputStreamWriter((OutputStream)os, DEFAULT_CHARSET);
        ow.write(text);
        ow.close();
        os.close();
    }

    public static void writeZipEntry(ZipOutputStream zip, File fileRead) throws IOException {
        try (FileInputStream in = new FileInputStream(fileRead);){
            byte[] array = new byte[8192];
            while (in.read(array) != -1) {
                zip.write(array);
            }
        }
        catch (IOException e) {
            throw new IOException(e);
        }
    }

    public static String readStream(InputStream is, String charset) throws IOException {
        try (InputStreamReader reader = new InputStreamReader((InputStream)new BufferedInputStream(is), charset);){
            StringBuilder b = new StringBuilder();
            while (reader.ready()) {
                b.append((char)reader.read());
            }
            String string = b.toString();
            return string;
        }
    }

    public static String readStream(InputStream is) throws IOException {
        return FileUtil.readStream(is, Charsets.UTF_8.displayName());
    }

    public static String getTextResource(URL url, String charset) throws IOException {
        return FileUtil.readStream(url.openStream(), charset);
    }

    public static String readFile(File file, String charset) throws IOException {
        return FileUtil.readStream(new FileInputStream(file), charset);
    }

    public static String readFile(File file) throws IOException {
        return FileUtil.readFile(file, DEFAULT_CHARSET);
    }

    public static String getFilename(String path) {
        String[] folders = path.split("/");
        int size = folders.length;
        if (size == 0) {
            return "";
        }
        return folders[size - 1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDigest(File file, String algorithm, int hashLength) {
        DigestInputStream stream = null;
        try {
            int read;
            stream = new DigestInputStream(new FileInputStream(file), MessageDigest.getInstance(algorithm));
            byte[] buffer = new byte[65536];
            while ((read = stream.read(buffer)) > 0) {
            }
            FileUtil.close(stream);
        }
        catch (Exception ignored) {
            String string = null;
            return string;
        }
        finally {
            FileUtil.close(stream);
        }
        return String.format("%1$0" + hashLength + "x", new BigInteger(1, stream.getMessageDigest().digest()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] createChecksum(File file, String algorithm) {
        BufferedInputStream fis = null;
        try {
            int numRead;
            fis = new BufferedInputStream(new FileInputStream(file));
            byte[] buffer = new byte[8192];
            MessageDigest complete = MessageDigest.getInstance(algorithm);
            do {
                if ((numRead = ((InputStream)fis).read(buffer)) <= 0) continue;
                complete.update(buffer, 0, numRead);
            } while (numRead != -1);
            byte[] byArray = complete.digest();
            FileUtil.close(fis);
            return byArray;
        }
        catch (Exception e) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            FileUtil.close(fis);
        }
    }

    public static String getChecksum(File file, String algorithm) {
        if (file == null) {
            return null;
        }
        if (!file.exists()) {
            return null;
        }
        byte[] b = FileUtil.createChecksum(file, algorithm);
        if (b == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (byte cb : b) {
            result.append(Integer.toString((cb & 0xFF) + 256, 16).substring(1));
        }
        return result.toString();
    }

    public static String getChecksum(File file) {
        return FileUtil.getChecksum(file, "SHA-1");
    }

    private static void close(Closeable a) {
        try {
            a.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static File getRunningJar() {
        try {
            return new File(URLDecoder.decode(FileUtil.class.getProtectionDomain().getCodeSource().getLocation().getPath(), DEFAULT_CHARSET));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Cannot get running file!", e);
        }
    }

    public static void copyFile(File source, File dest, boolean replace) throws IOException {
        if (dest.isFile()) {
            if (!replace) {
                return;
            }
        } else {
            FileUtil.createFile(dest);
        }
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(source));
             BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(dest));){
            int length;
            byte[] buffer = new byte[1024];
            while ((length = ((InputStream)is).read(buffer)) > 0) {
                ((OutputStream)os).write(buffer, 0, length);
            }
        }
    }

    public static void deleteFile(File file) {
        boolean onExit;
        boolean bl = onExit = !file.delete();
        if (onExit) {
            file.deleteOnExit();
            return;
        }
        File parent = file.getParentFile();
        if (parent == null) {
            return;
        }
        File[] list = parent.listFiles();
        if (list == null || list.length > 0) {
            return;
        }
        FileUtil.deleteFile(parent);
    }

    public static void deleteDirectory(File dir) {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("Specified path is not a directory: " + dir.getAbsolutePath());
        }
        File[] files = dir.listFiles();
        if (Objects.isNull(files)) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                FileUtil.deleteDirectory(file);
                continue;
            }
            FileUtil.deleteFile(file);
        }
        FileUtil.deleteFile(dir);
    }

    public static File makeTemp(File file) throws IOException {
        FileUtil.createFile(file);
        file.deleteOnExit();
        return file;
    }

    public static boolean createFolder(File dir) throws IOException {
        if (dir == null) {
            throw new NullPointerException();
        }
        if (dir.isDirectory()) {
            return false;
        }
        if (!dir.mkdirs()) {
            throw new IOException("Cannot createScrollWrapper folders: " + dir.getAbsolutePath());
        }
        if (!dir.canWrite()) {
            throw new IOException("Created directory is not accessible: " + dir.getAbsolutePath());
        }
        return true;
    }

    public static void createFile(File file) throws IOException {
        if (file.isFile()) {
            return;
        }
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        if (!file.createNewFile()) {
            throw new IOException("Cannot createScrollWrapper file, or it was created during runtime: " + file.getAbsolutePath());
        }
    }

    public static void unTarGz(File zip, File folder, boolean replace, boolean deleteEmptyFile) throws IOException {
        FileUtil.createFolder(folder);
        try (TarArchiveInputStream zis = new TarArchiveInputStream(new GzipCompressorInputStream(new BufferedInputStream(new FileInputStream(zip))));){
            TarArchiveEntry ze;
            while ((ze = (TarArchiveEntry)zis.getNextEntry()) != null) {
                String fileName = ze.getName();
                if (ze.isDirectory()) continue;
                FileUtil.unZipAndTarGz(fileName, folder, replace, zis, deleteEmptyFile);
            }
            zis.close();
        }
    }

    public static void unZip(File zip, File folder, boolean replace, boolean deleteEmptyFile) throws IOException {
        FileUtil.createFolder(folder);
        try (ZipInputStream zis = new ZipInputStream((InputStream)new BufferedInputStream(new FileInputStream(zip)), StandardCharsets.UTF_8);){
            ZipEntry ze;
            while ((ze = zis.getNextEntry()) != null) {
                String fileName = ze.getName();
                if (ze.isDirectory()) continue;
                FileUtil.unZipAndTarGz(fileName, folder, replace, zis, deleteEmptyFile);
            }
            zis.closeEntry();
        }
    }

    private static void unZipAndTarGz(String fileName, File folder, boolean replace, InputStream zis, boolean deleteEmptyFile) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        File newFile = new File(folder, fileName);
        if (!replace && newFile.isFile()) {
            return;
        }
        FileUtil.createFile(newFile);
        BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(newFile));
        int count = 0;
        while ((len = zis.read(buffer)) > 0) {
            count += len;
            ((OutputStream)fos).write(buffer, 0, len);
        }
        ((OutputStream)fos).close();
        if (deleteEmptyFile && count == 0) {
            Files.delete(newFile.toPath());
        }
    }

    public static void unZip(File zip, File folder, boolean replace) throws IOException {
        FileUtil.unZip(zip, folder, replace, true);
    }

    public static String getResource(URL resource, String charset) throws IOException {
        BufferedInputStream is = new BufferedInputStream(resource.openStream());
        InputStreamReader reader = new InputStreamReader((InputStream)is, charset);
        StringBuilder b = new StringBuilder();
        while (reader.ready()) {
            b.append((char)reader.read());
        }
        reader.close();
        return b.toString();
    }

    public static String getResource(URL resource) throws IOException {
        return FileUtil.getResource(resource, DEFAULT_CHARSET);
    }

    public static String getFolder(URL url, String separator) {
        String[] folders = url.toString().split(separator);
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < folders.length - 1; ++i) {
            s.append(folders[i]).append(separator);
        }
        return s.toString();
    }

    public static String getExtension(File f) {
        if (!f.isFile() && f.isDirectory()) {
            return null;
        }
        String ext = "";
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    public static boolean checkFreeSpace(File file, long size) {
        try {
            FileStore store = Files.getFileStore(file.toPath().getRoot());
            long res = store.getUsableSpace();
            return res > size;
        }
        catch (IOException iOException) {
            return true;
        }
    }

    public static InputStream getResourceAppStream(String name) {
        return FileUtil.class.getResourceAsStream(name);
    }

    public static Path getRelative(String path) {
        return Paths.get(MinecraftUtil.getWorkingDirectory().getAbsolutePath(), path);
    }

    public static Path getRelativeConfig(String path) {
        return FileUtil.getRelative(TLauncher.getInnerSettings().get(path));
    }

    public static File getRelativeConfigFile(String path) {
        return FileUtil.getRelative(TLauncher.getInnerSettings().get(path)).toFile();
    }

    public static List<String> topFolders(Archive rar) {
        FileHeader fh = rar.nextFileHeader();
        HashSet<String> list = new HashSet<String>();
        while (fh != null) {
            String line = Paths.get(fh.getFileNameW(), new String[0]).toString();
            if (line.indexOf(File.separator) > 0) {
                list.add(line.substring(0, line.indexOf(File.separator)));
            }
            fh = rar.nextFileHeader();
        }
        return new ArrayList<String>(list);
    }

    public static List<String> topFolders(ZipFile zipFile) {
        HashSet<String> list = new HashSet<String>();
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String name = entry.getName();
            int index = name.indexOf("/");
            if (index <= 0) continue;
            list.add(name.substring(0, index));
        }
        IOUtils.closeQuietly((Closeable)zipFile);
        return new ArrayList<String>(list);
    }

    public static MetadataDTO createMetadata(File file, File rootFolder, Class<? extends GameEntityDTO> c) {
        MetadataDTO metadata;
        if (c == MapDTO.class) {
            MapMetadataDTO map = new MapMetadataDTO();
            map.setFolders(Lists.newArrayList((Object[])new String[]{file.getName()}));
            metadata = map;
        } else {
            metadata = new MetadataDTO();
            metadata.setSha1(FileUtil.getChecksum(file, "SHA-1"));
            metadata.setSize(file.length());
        }
        metadata.setPath(rootFolder.toPath().relativize(file.toPath()).toString().replace("\\", "/"));
        metadata.setUrl(rootFolder.toPath().relativize(file.toPath()).toString().replace("\\", "/"));
        return metadata;
    }

    public static void zipFiles(List<File> files, Path root, File result) throws IOException {
        FileOutputStream fos = new FileOutputStream(result);
        ZipOutputStream zipOut = new ZipOutputStream((OutputStream)new BufferedOutputStream(fos), StandardCharsets.UTF_8);
        for (File input : files) {
            int size;
            FileInputStream fis = new FileInputStream(input);
            ZipEntry ze = new ZipEntry(root.relativize(input.toPath()).toString().replaceAll("\\\\", "/"));
            zipOut.putNextEntry(ze);
            byte[] tmp = new byte[4096];
            while ((size = fis.read(tmp)) != -1) {
                zipOut.write(tmp, 0, size);
            }
            zipOut.flush();
            fis.close();
        }
        zipOut.close();
    }

    public static void backupModpacks(Map<String, String> map, List<File> files, Path root, File result, List<String> modpacks) throws IOException {
        FileOutputStream fos = new FileOutputStream(result);
        ZipOutputStream zipOut = new ZipOutputStream((OutputStream)new BufferedOutputStream(fos), StandardCharsets.UTF_8);
        for (File input : files) {
            int size;
            InputStream fis = map.containsKey(input.getName()) ? new ByteArrayInputStream(map.get(input.getName()).getBytes(StandardCharsets.UTF_8)) : new FileInputStream(input);
            ZipEntry ze = new ZipEntry(root.relativize(input.toPath()).toString().replaceAll("\\\\", "/"));
            U.log(ze.getName());
            zipOut.putNextEntry(ze);
            byte[] tmp = new byte[4096];
            while ((size = fis.read(tmp)) != -1) {
                zipOut.write(tmp, 0, size);
            }
            zipOut.flush();
            fis.close();
        }
        zipOut.close();
    }

    public static void unzipUniversal(File file, File folder) throws IOException, ParseModPackException {
        String ext;
        switch (ext = FilenameUtils.getExtension(file.getCanonicalPath())) {
            case "rar": {
                ExtractArchive extractArchive = new ExtractArchive();
                extractArchive.extractArchive(file, folder);
                break;
            }
            case "zip": {
                FileUtil.unZip(file, folder, true);
                break;
            }
            default: {
                throw new ParseModPackException("problem with format of the modpack");
            }
        }
    }

    public static void zipFolder(File srcFolder, File destZipFile) throws Exception {
        List files = (List)FileUtils.listFiles(srcFolder, TrueFileFilter.INSTANCE, TrueFileFilter.INSTANCE);
        FileUtil.zipFiles(files, srcFolder.toPath().getParent(), destZipFile);
    }

    public static String readZippedFile(File file, String name) throws IOException {
        try (ZipFile f = new ZipFile(file);){
            Enumeration<? extends ZipEntry> en = f.entries();
            while (en.hasMoreElements()) {
                ZipEntry entry = en.nextElement();
                if (!entry.getName().endsWith(name)) continue;
                String string = FileUtil.readStream(f.getInputStream(entry));
                return string;
            }
        }
        throw new FileNotFoundException(file.toString());
    }

    public static enum GameEntityFolder {
        MODS,
        RESOURCEPACKS,
        MAPS,
        SAVES,
        RESOURCES,
        SHADERPACKS;


        public String toString() {
            return super.toString().toLowerCase();
        }

        public static String getPath(GameType type) {
            switch (type) {
                case MOD: {
                    return MODS.toString().toLowerCase();
                }
                case MAP: {
                    return SAVES.toString().toLowerCase();
                }
                case RESOURCEPACK: {
                    return RESOURCEPACKS.toString().toLowerCase();
                }
                case SHADERPACK: {
                    return SHADERPACKS.toString().toLowerCase();
                }
            }
            return "";
        }

        public static String getPath(Class<? extends GameEntityDTO> type, boolean folderSeparate) {
            String path = "";
            if (type == ModDTO.class) {
                path = GameEntityFolder.getPath(GameType.MOD);
            } else if (type == MapDTO.class) {
                path = GameEntityFolder.getPath(GameType.MAP);
            } else if (type == ResourcePackDTO.class) {
                path = GameEntityFolder.getPath(GameType.RESOURCEPACK);
            } else if (type == ShaderpackDTO.class) {
                path = GameEntityFolder.getPath(GameType.SHADERPACK);
            }
            if (folderSeparate) {
                return path + "/";
            }
            return path;
        }
    }
}

