/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.updater.client;

import com.google.gson.GsonBuilder;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.minecraft.launcher.Http;
import org.apache.commons.io.IOUtils;
import org.tlauncher.tlauncher.downloader.Downloadable;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.updater.client.Update;
import org.tlauncher.tlauncher.updater.client.UpdaterListener;
import org.tlauncher.util.U;
import org.tlauncher.util.async.AsyncThread;
import org.tlauncher.util.gson.serializer.UpdateDeserializer;

public class Updater {
    private Update update;
    private final List<UpdaterListener> listeners = Collections.synchronizedList(new ArrayList());

    public Update getUpdate() {
        return this.update;
    }

    protected SearchResult findUpdate0() {
        SearchResult result = null;
        this.log("Requesting an update...");
        ArrayList<Throwable> errorList = new ArrayList<Throwable>();
        String get = "?version=" + Http.encode(String.valueOf(TLauncher.getVersion())) + "&client=" + Http.encode(TLauncher.getInstance().getConfiguration().getClient().toString());
        String type = TLauncher.getInnerSettings().get("type").toLowerCase(Locale.ROOT);
        for (String updateUrl : this.getUpdateUrlList()) {
            updateUrl = String.format(updateUrl, type);
            long startTime = System.currentTimeMillis();
            this.log("Requesting from:", updateUrl);
            String response = null;
            try {
                URL url = new URL(updateUrl + get);
                this.log("Making request:", url);
                HttpURLConnection connection = Downloadable.setUp(url.openConnection(U.getProxy()), true);
                connection.setDoOutput(true);
                response = IOUtils.toString(new InputStreamReader(connection.getInputStream(), Charset.forName("UTF-8")));
                Update update = new GsonBuilder().registerTypeAdapter((Type)((Object)Update.class), new UpdateDeserializer()).create().fromJson(response, Update.class);
                result = new SearchSucceeded(update);
            }
            catch (Exception e) {
                this.log("Failed to request from:", updateUrl, e);
                if (response != null) {
                    this.log("Response:", response);
                }
                result = null;
                errorList.add(e);
            }
            this.log("Request time:", System.currentTimeMillis() - startTime, "ms");
            if (result == null) continue;
            this.log("Successfully requested from:", updateUrl);
            break;
        }
        return result == null ? new SearchFailed(errorList) : result;
    }

    private SearchResult findUpdate() {
        try {
            SearchResult result = this.findUpdate0();
            this.dispatchResult(result);
            return result;
        }
        catch (Exception e) {
            this.log(e);
            return null;
        }
    }

    public void asyncFindUpdate() {
        AsyncThread.execute(() -> this.findUpdate());
    }

    public void addListener(UpdaterListener l) {
        this.listeners.add(l);
    }

    public void removeListener(UpdaterListener l) {
        this.listeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchResult(SearchResult result) {
        Updater.requireNotNull(result, "result");
        if (result instanceof SearchSucceeded) {
            List<UpdaterListener> list = this.listeners;
            synchronized (list) {
                for (UpdaterListener l : this.listeners) {
                    l.onUpdaterSucceeded((SearchSucceeded)result);
                }
            }
        } else if (result instanceof SearchFailed) {
            List<UpdaterListener> list = this.listeners;
            synchronized (list) {
                for (UpdaterListener l : this.listeners) {
                    l.onUpdaterErrored((SearchFailed)result);
                }
            }
        } else {
            throw new IllegalArgumentException("unknown result of " + result.getClass());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onUpdaterRequests() {
        List<UpdaterListener> list = this.listeners;
        synchronized (list) {
            for (UpdaterListener l : this.listeners) {
                l.onUpdaterRequesting(this);
            }
        }
    }

    protected List<String> getUpdateUrlList() {
        return Arrays.asList(TLauncher.getUpdateRepos());
    }

    protected void log(Object ... o) {
        U.log("[Updater]", o);
    }

    private static <T> T requireNotNull(T obj, String name) {
        if (obj == null) {
            throw new NullPointerException(name);
        }
        return obj;
    }

    public class SearchFailed
    extends SearchResult {
        protected final List<Throwable> errorList;

        public SearchFailed(List<Throwable> list) {
            super(null);
            this.errorList = new ArrayList<Throwable>();
            for (Throwable t : list) {
                if (t != null) continue;
                throw new NullPointerException();
            }
            this.errorList.addAll(list);
        }

        public final List<Throwable> getCauseList() {
            return this.errorList;
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + "{errors=" + this.errorList + "}";
        }
    }

    public class SearchSucceeded
    extends SearchResult {
        public SearchSucceeded(Update response) {
            super((Update)Updater.requireNotNull(response, "response"));
        }
    }

    public abstract class SearchResult {
        protected final Update response;

        public SearchResult(Update response) {
            this.response = response;
        }

        public final Update getResponse() {
            return this.response;
        }

        public final Updater getUpdater() {
            return Updater.this;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{response=" + this.response + "}";
        }
    }
}

