/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.versions;

import java.awt.Color;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPopupMenu;
import net.minecraft.launcher.updater.VersionSyncInfo;
import org.tlauncher.tlauncher.downloader.AbortedDownloadException;
import org.tlauncher.tlauncher.downloader.DownloadableContainer;
import org.tlauncher.tlauncher.managers.VersionManager;
import org.tlauncher.tlauncher.managers.VersionSyncInfoContainer;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.alert.Alert;
import org.tlauncher.tlauncher.ui.block.Blockable;
import org.tlauncher.tlauncher.ui.block.Unblockable;
import org.tlauncher.tlauncher.ui.images.ImageCache;
import org.tlauncher.tlauncher.ui.loc.ImageUdaterButton;
import org.tlauncher.tlauncher.ui.loc.Localizable;
import org.tlauncher.tlauncher.ui.loc.LocalizableMenuItem;
import org.tlauncher.tlauncher.ui.versions.VersionHandler;
import org.tlauncher.tlauncher.ui.versions.VersionHandlerListener;
import org.tlauncher.tlauncher.ui.versions.VersionList;

public class VersionDownloadButton
extends ImageUdaterButton
implements VersionHandlerListener,
Unblockable {
    private static final String SELECTION_BLOCK = "selection";
    private static final String PREFIX = "version.manager.downloader.";
    private static final String WARNING = "version.manager.downloader.warning.";
    private static final String WARNING_TITLE = "version.manager.downloader.warning.title";
    private static final String WARNING_FORCE = "version.manager.downloader.warning.force.";
    private static final String ERROR = "version.manager.downloader.error.";
    private static final String ERROR_TITLE = "version.manager.downloader.error.title";
    private static final String INFO = "version.manager.downloader.info.";
    private static final String INFO_TITLE = "version.manager.downloader.info.title";
    private static final String MENU = "version.manager.downloader.menu.";
    final VersionHandler handler;
    final Blockable blockable;
    private final JPopupMenu menu;
    private final LocalizableMenuItem ordinary;
    private final LocalizableMenuItem force;
    private ButtonState state;
    private boolean downloading;
    private boolean aborted;
    boolean forceDownload;

    VersionDownloadButton(VersionList list) {
        super(Color.WHITE);
        this.handler = list.handler;
        this.blockable = new Blockable(){

            @Override
            public void block(Object reason) {
                VersionDownloadButton.this.setEnabled(false);
            }

            @Override
            public void unblock(Object reason) {
                VersionDownloadButton.this.setEnabled(true);
            }
        };
        this.menu = new JPopupMenu();
        this.ordinary = new LocalizableMenuItem("version.manager.downloader.menu.ordinary");
        this.ordinary.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VersionDownloadButton.this.forceDownload = false;
                VersionDownloadButton.this.onDownloadCalled();
            }
        });
        this.menu.add(this.ordinary);
        this.force = new LocalizableMenuItem("version.manager.downloader.menu.force");
        this.force.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        this.menu.add(this.force);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VersionDownloadButton.this.onPressed();
            }
        });
        this.setState(ButtonState.DOWNLOAD);
        this.handler.addListener(this);
    }

    void setState(ButtonState state) {
        if (state == null) {
            throw new NullPointerException();
        }
        this.state = state;
        this.setImage(state.image);
    }

    void onPressed() {
        switch (this.state) {
            case DOWNLOAD: {
                this.forceDownload = true;
                this.onDownloadCalled();
                break;
            }
            case STOP: {
                this.onStopCalled();
            }
        }
    }

    void onDownloadPressed() {
        this.menu.show(this, 0, this.getHeight());
    }

    void onDownloadCalled() {
        if (this.state != ButtonState.DOWNLOAD) {
            throw new IllegalStateException();
        }
        this.handler.thread.startThread.iterate();
    }

    void onStopCalled() {
        if (this.state != ButtonState.STOP) {
            throw new IllegalStateException();
        }
        this.handler.thread.stopThread.iterate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startDownload() {
        this.aborted = false;
        List<VersionSyncInfo> list = this.handler.getSelectedList();
        if (list == null || list.isEmpty()) {
            return;
        }
        int countLocal = 0;
        VersionSyncInfo local = null;
        for (VersionSyncInfo version : list) {
            if (!this.forceDownload) continue;
            if (!version.hasRemote()) {
                Alert.showError(Localizable.get(ERROR_TITLE), Localizable.get("version.manager.downloader.error.local", version.getID()));
                return;
            }
            if (!version.isUpToDate() || !version.isInstalled()) continue;
            ++countLocal;
            local = version;
        }
        if (countLocal > 0) {
            Object var;
            String suffix;
            String title = Localizable.get(WARNING_TITLE);
            if (countLocal == 1) {
                suffix = "single";
                var = local.getID();
            } else {
                suffix = "multiply";
                var = countLocal;
            }
            if (!Alert.showQuestion(title, Localizable.get(WARNING_FORCE + suffix, var))) {
                return;
            }
        }
        ArrayList<VersionSyncInfoContainer> containers = new ArrayList<VersionSyncInfoContainer>();
        VersionManager manager = TLauncher.getInstance().getVersionManager();
        try {
            this.downloading = true;
            for (VersionSyncInfo versionSyncInfo : list) {
                VersionSyncInfoContainer container;
                block26: {
                    try {
                        versionSyncInfo.resolveCompleteVersion(manager, this.forceDownload);
                        container = manager.downloadVersion(versionSyncInfo, false, this.forceDownload);
                        if (!this.aborted) break block26;
                        return;
                    }
                    catch (Exception e) {
                        Alert.showError(Localizable.get(ERROR_TITLE), Localizable.get("version.manager.downloader.error.getting", versionSyncInfo.getID()), e);
                        this.downloading = false;
                        return;
                    }
                }
                if (container.getList().isEmpty()) continue;
                containers.add(container);
            }
            if (containers.isEmpty()) {
                Alert.showMessage(Localizable.get(INFO_TITLE), Localizable.get("version.manager.downloader.info.no-needed"));
                return;
            }
            if (containers.size() > 1) {
                DownloadableContainer.removeDuplicates(containers);
            }
            if (this.aborted) {
                return;
            }
            for (DownloadableContainer downloadableContainer : containers) {
                this.handler.downloader.add(downloadableContainer);
            }
            this.handler.downloading = list;
            this.handler.onVersionDownload(list);
            this.handler.downloader.startDownloadAndWait();
        }
        finally {
            this.downloading = false;
        }
        this.handler.downloading.clear();
        for (VersionSyncInfoContainer versionSyncInfoContainer : containers) {
            List<Throwable> errors = versionSyncInfoContainer.getErrors();
            VersionSyncInfo version = versionSyncInfoContainer.getVersion();
            if (errors.isEmpty()) {
                try {
                    manager.getLocalList().saveVersion(version.getCompleteVersion(this.forceDownload));
                    continue;
                }
                catch (IOException e) {
                    Alert.showError(Localizable.get(ERROR_TITLE), Localizable.get("version.manager.downloader.error.saving", version.getID()), e);
                    return;
                }
            }
            if (errors.get(0) instanceof AbortedDownloadException) continue;
            Alert.showError(Localizable.get(ERROR_TITLE), Localizable.get("version.manager.downloader.error.downloading", version.getID()), errors);
        }
        this.handler.refresh();
    }

    void stopDownload() {
        this.aborted = true;
        if (this.downloading) {
            this.handler.downloader.stopDownloadAndWait();
        }
    }

    @Override
    public void onVersionRefreshing(VersionManager vm) {
    }

    @Override
    public void onVersionRefreshed(VersionManager vm) {
    }

    @Override
    public void onVersionSelected(List<VersionSyncInfo> versions) {
        if (!this.downloading) {
            this.blockable.unblock(SELECTION_BLOCK);
        }
    }

    @Override
    public void onVersionDeselected() {
        if (!this.downloading) {
            this.blockable.block(SELECTION_BLOCK);
        }
    }

    @Override
    public void onVersionDownload(List<VersionSyncInfo> list) {
    }

    public static enum ButtonState {
        DOWNLOAD("down.png"),
        STOP("cancel.png");

        final Image image;

        private ButtonState(String image) {
            this.image = ImageCache.getImage((String)image);
        }
    }
}

