/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import org.tlauncher.modpack.domain.client.share.MinecraftVersionDTO;
import org.tlauncher.modpack.domain.client.share.VersionMaturity;
import org.tlauncher.tlauncher.ui.images.ImageCache;
import org.tlauncher.tlauncher.ui.loc.ImageUdaterButton;
import org.tlauncher.tlauncher.ui.ui.ModpackScrollBarUI;
import org.tlauncher.util.ColorUtil;

public abstract class CreationModpackComboBoxUI
extends BasicComboBoxUI {
    private static Icon ICON_STAR = ImageCache.getIcon((String)"star-true.png");
    private static Icon ICON_STAR_FALSE = ImageCache.getIcon((String)"star-false.png");
    private int leftTextGup = 14;

    @Override
    protected JButton createArrowButton() {
        ImageUdaterButton button = new ImageUdaterButton(Color.WHITE, "gray-combobox-array.png");
        for (ActionListener l : button.getActionListeners()) {
            button.removeActionListener(l);
        }
        button.setModelPressedColor(ColorUtil.COLOR_195);
        return button;
    }

    @Override
    protected ComboPopup createPopup() {
        BasicComboPopup basic = new BasicComboPopup(this.comboBox){
            private static final long serialVersionUID = -1200285237129861017L;

            @Override
            protected JScrollPane createScroller() {
                ModpackScrollBarUI barUI = new ModpackScrollBarUI(){

                    @Override
                    protected Dimension getMinimumThumbSize() {
                        return new Dimension(10, 40);
                    }

                    @Override
                    public Dimension getMaximumSize(JComponent c) {
                        Dimension dim = super.getMaximumSize(c);
                        dim.setSize(10.0, dim.getHeight());
                        return dim;
                    }

                    @Override
                    public Dimension getPreferredSize(JComponent c) {
                        Dimension dim = super.getPreferredSize(c);
                        dim.setSize(13.0, dim.getHeight());
                        return dim;
                    }
                };
                barUI.setGapThubm(5);
                JScrollPane scroller = new JScrollPane(this.list, 20, 31);
                scroller.setBackground(Color.WHITE);
                scroller.getVerticalScrollBar().setUI(barUI);
                return scroller;
            }
        };
        basic.setBorder(BorderFactory.createMatteBorder(0, 1, 1, 1, new Color(149, 149, 149)));
        return basic;
    }

    @Override
    public void paintCurrentValue(Graphics g, Rectangle bounds, boolean hasFocus) {
        g.setColor(Color.WHITE);
        g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
        Object ob = this.comboBox.getSelectedItem();
        this.paintText(g, bounds, Objects.isNull(ob) ? "" : this.getText(ob));
    }

    protected void paintText(Graphics g, Rectangle textRect, String text) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        FontMetrics fm = g2d.getFontMetrics();
        Rectangle2D r = fm.getStringBounds(text, g2d);
        g.setFont(this.comboBox.getFont());
        g.setColor(new Color(25, 25, 25));
        int y = (textRect.height - (int)r.getHeight()) / 2 + fm.getAscent();
        g2d.drawString(text, this.leftTextGup, y);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        PositionIcon pi = CreationModpackComboBoxUI.getRenderIconStatic(this.comboBox.getSelectedItem());
        if (Objects.nonNull(pi)) {
            y = (textRect.height - pi.getIcon().getIconHeight()) / 2;
            int x = this.leftTextGup + (int)r.getWidth() + 4;
            pi.getIcon().paintIcon(this.comboBox, g, x, y);
        }
    }

    public abstract String getText(Object var1);

    public PositionIcon getRenderIcon1(Object value) {
        return CreationModpackComboBoxUI.getRenderIconStatic(value);
    }

    public static PositionIcon getRenderIconStatic(Object value) {
        if (Objects.isNull(value) || !(value instanceof MinecraftVersionDTO)) {
            return null;
        }
        MinecraftVersionDTO dto = (MinecraftVersionDTO)value;
        if (VersionMaturity.PROMO_RECOMMEDED.equals((Object)dto.getMaturity())) {
            return new PositionIcon(ICON_STAR, 2);
        }
        if (VersionMaturity.PROMO_LATEST.equals((Object)dto.getMaturity())) {
            return new PositionIcon(ICON_STAR_FALSE, 2);
        }
        return null;
    }

    public void setLeftTextGup(int leftTextGup) {
        this.leftTextGup = leftTextGup;
    }

    public static class PositionIcon {
        private Icon icon;
        private int iconPosition;

        public Icon getIcon() {
            return this.icon;
        }

        public int getIconPosition() {
            return this.iconPosition;
        }

        public void setIcon(Icon icon) {
            this.icon = icon;
        }

        public void setIconPosition(int iconPosition) {
            this.iconPosition = iconPosition;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PositionIcon)) {
                return false;
            }
            PositionIcon other = (PositionIcon)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Icon this$icon = this.getIcon();
            Icon other$icon = other.getIcon();
            if (this$icon == null ? other$icon != null : !this$icon.equals(other$icon)) {
                return false;
            }
            return this.getIconPosition() == other.getIconPosition();
        }

        protected boolean canEqual(Object other) {
            return other instanceof PositionIcon;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Icon $icon = this.getIcon();
            result = result * 59 + ($icon == null ? 43 : $icon.hashCode());
            result = result * 59 + this.getIconPosition();
            return result;
        }

        public String toString() {
            return "CreationModpackComboBoxUI.PositionIcon(icon=" + this.getIcon() + ", iconPosition=" + this.getIconPosition() + ")";
        }

        public PositionIcon(Icon icon, int iconPosition) {
            this.icon = icon;
            this.iconPosition = iconPosition;
        }
    }
}

