/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.settings;

import by.gdev.util.DesktopUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import org.tlauncher.tlauncher.configuration.Configuration;
import org.tlauncher.tlauncher.configuration.LangConfiguration;
import org.tlauncher.tlauncher.configuration.enums.ActionOnLaunch;
import org.tlauncher.tlauncher.configuration.enums.BackupFrequency;
import org.tlauncher.tlauncher.configuration.enums.ConnectionQuality;
import org.tlauncher.tlauncher.configuration.enums.ConsoleType;
import org.tlauncher.tlauncher.controller.StatisticsController;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.alert.Alert;
import org.tlauncher.tlauncher.ui.converter.ActionOnLaunchConverter;
import org.tlauncher.tlauncher.ui.converter.BackupFrequencyConverter;
import org.tlauncher.tlauncher.ui.converter.ConnectionQualityConverter;
import org.tlauncher.tlauncher.ui.converter.ConsoleTypeConverter;
import org.tlauncher.tlauncher.ui.converter.LocaleConverter;
import org.tlauncher.tlauncher.ui.editor.EditorCheckBox;
import org.tlauncher.tlauncher.ui.editor.EditorComboBox;
import org.tlauncher.tlauncher.ui.images.ImageCache;
import org.tlauncher.tlauncher.ui.loc.Localizable;
import org.tlauncher.tlauncher.ui.loc.LocalizableLabel;
import org.tlauncher.tlauncher.ui.loc.UpdaterButton;
import org.tlauncher.tlauncher.ui.modpack.AboutApplicationFrame;
import org.tlauncher.tlauncher.ui.settings.HandlerSettings;
import org.tlauncher.tlauncher.ui.settings.PageSettings;
import org.tlauncher.tlauncher.ui.settings.SettingElement;
import org.tlauncher.tlauncher.ui.swing.HtmlTextPane;
import org.tlauncher.tlauncher.ui.swing.extended.HTMLLabel;
import org.tlauncher.tlauncher.ui.swing.scroll.VersionScrollBarUI;
import org.tlauncher.tlauncher.ui.ui.TlauncherBasicComboBoxUI;
import org.tlauncher.util.OS;
import org.tlauncher.util.SwingUtil;
import org.tlauncher.util.U;
import org.tlauncher.util.swing.FontTL;

public class ConfidentialitySetting
extends PageSettings {
    private static final long serialVersionUID = -2705671690811623008L;
    public final TLauncher tlauncher = TLauncher.getInstance();
    public final Configuration global = this.tlauncher.getConfiguration();
    public final LangConfiguration lang = this.tlauncher.getLang();
    private final EditorComboBox<Locale> local;
    private HTMLLabel documentText;
    HtmlTextPane html;

    public ConfidentialitySetting() {
        SpringLayout springLayout = new SpringLayout();
        this.setLayout(springLayout);
        final Color backgroundOldButtonColor = new Color(219, 64, 44);
        Font font = new JButton().getFont().deriveFont(1, 13.0f);
        final UpdaterButton errorButton = new UpdaterButton(backgroundOldButtonColor, new Color(189, 64, 44), "settings.delete");
        errorButton.setFont(font);
        errorButton.setForeground(Color.WHITE);
        final StatisticsController statisticsController = (StatisticsController)TLauncher.getInjector().getInstance(StatisticsController.class);
        EditorComboBox<ConsoleType> consoleConverter = new EditorComboBox<ConsoleType>(new ConsoleTypeConverter(), ConsoleType.values());
        EditorCheckBox statistics = new EditorCheckBox("statistics.settings.checkbox.name");
        statistics.setForeground(Color.BLACK);
        EditorCheckBox guard = new EditorCheckBox("settings.guard");
        guard.setForeground(Color.BLACK);
        EditorCheckBox turnOffDiscord = new EditorCheckBox("settings.discord.off");
        turnOffDiscord.setForeground(Color.BLACK);
        EditorCheckBox recommendedServers = new EditorCheckBox("settings.servers.recommendation");
        recommendedServers.setForeground(Color.BLACK);
        this.documentText = new HTMLLabel();
        this.documentText.setHorizontalAlignment(0);
        final JLabel questionLabel = new JLabel(ImageCache.getNativeIcon((String)"qestion-option-panel.png"));
        EditorComboBox<ConnectionQuality> connQuality = new EditorComboBox<ConnectionQuality>(new ConnectionQualityConverter(), ConnectionQuality.values());
        EditorComboBox<ActionOnLaunch> launchAction = new EditorComboBox<ActionOnLaunch>(new ActionOnLaunchConverter(), ActionOnLaunch.values());
        EditorComboBox<BackupFrequency> backupFrequency = new EditorComboBox<BackupFrequency>(new BackupFrequencyConverter(), BackupFrequency.values());
        this.local = new EditorComboBox<Locale>(new LocaleConverter(), this.global.getLocales());
        UpdaterButton programJava = new UpdaterButton(UpdaterButton.GREEN_COLOR, new Color(10, 190, 45), "settings.select.program");
        programJava.setFont(font);
        programJava.setForeground(Color.WHITE);
        ConfidentialitySetting.setTLauncherBasicComboBoxUI(consoleConverter);
        ConfidentialitySetting.setTLauncherBasicComboBoxUI(connQuality);
        ConfidentialitySetting.setTLauncherBasicComboBoxUI(launchAction);
        ConfidentialitySetting.setTLauncherBasicComboBoxUI(this.local);
        ConfidentialitySetting.setTLauncherBasicComboBoxUI(backupFrequency);
        SettingElement settingElement_2 = new SettingElement("statistics.settings.title", statistics, 17, -1);
        springLayout.putConstraint("North", (Component)settingElement_2, 0, "North", (Component)this);
        springLayout.putConstraint("West", (Component)settingElement_2, 0, "West", (Component)this);
        springLayout.putConstraint("South", (Component)settingElement_2, 21, "North", (Component)this);
        springLayout.putConstraint("East", (Component)settingElement_2, 0, "East", (Component)this);
        this.add((Component)settingElement_2);
        SettingElement settingElement_guard = new SettingElement("settings.guard.title", (JComponent)guard, 19, -1, questionLabel);
        questionLabel.setBounds(0, 0, 20, 19);
        springLayout.putConstraint("North", (Component)settingElement_guard, 10, "South", (Component)settingElement_2);
        springLayout.putConstraint("West", (Component)settingElement_guard, 0, "West", (Component)this);
        springLayout.putConstraint("East", (Component)settingElement_guard, 0, "East", (Component)this);
        springLayout.putConstraint("South", (Component)settingElement_guard, 38, "South", (Component)settingElement_2);
        this.add((Component)settingElement_guard);
        SettingElement settingElement_discord = new SettingElement("Discord", turnOffDiscord, 19, -1);
        springLayout.putConstraint("North", (Component)settingElement_discord, 10, "South", (Component)settingElement_guard);
        springLayout.putConstraint("West", (Component)settingElement_discord, 0, "West", (Component)this);
        springLayout.putConstraint("East", (Component)settingElement_discord, 0, "East", (Component)this);
        springLayout.putConstraint("South", (Component)settingElement_discord, 38, "South", (Component)settingElement_guard);
        this.add((Component)settingElement_discord);
        this.html = HtmlTextPane.createNew(Localizable.get("settings.servers.analytics"), 400);
        SettingElement settingElement_servers = new SettingElement("settings.servers.recommendation.title", recommendedServers, 19, -1);
        springLayout.putConstraint("North", (Component)settingElement_servers, 10, "South", (Component)settingElement_discord);
        springLayout.putConstraint("West", (Component)settingElement_servers, 0, "West", (Component)this);
        springLayout.putConstraint("East", (Component)settingElement_servers, 0, "East", (Component)this);
        springLayout.putConstraint("South", (Component)settingElement_servers, 50, "South", (Component)settingElement_discord);
        this.add((Component)settingElement_servers);
        SettingElement settingElement_analytics = new SettingElement("settings.servers.analytics.title", (JComponent)this.html, 19, -1, 1);
        springLayout.putConstraint("North", (Component)settingElement_analytics, 10, "South", (Component)settingElement_servers);
        springLayout.putConstraint("West", (Component)settingElement_analytics, 0, "West", (Component)this);
        springLayout.putConstraint("East", (Component)settingElement_analytics, 0, "East", (Component)this);
        springLayout.putConstraint("South", (Component)settingElement_analytics, 185, "South", (Component)settingElement_servers);
        this.add((Component)settingElement_analytics);
        SettingElement settingElement_delete_analytics = new SettingElement("", errorButton, 19, -1);
        springLayout.putConstraint("North", (Component)settingElement_delete_analytics, -20, "South", (Component)settingElement_analytics);
        springLayout.putConstraint("West", (Component)settingElement_delete_analytics, 220, "West", (Component)this);
        springLayout.putConstraint("East", (Component)settingElement_delete_analytics, -100, "East", (Component)this);
        springLayout.putConstraint("South", (Component)settingElement_delete_analytics, 5, "South", (Component)settingElement_analytics);
        this.add((Component)settingElement_delete_analytics);
        SettingElement settingElement_document = new SettingElement("settings.servers.document.title", this.documentText, 19, -1);
        springLayout.putConstraint("North", (Component)settingElement_document, 15, "South", (Component)settingElement_delete_analytics);
        springLayout.putConstraint("West", (Component)settingElement_document, 10, "West", (Component)this);
        springLayout.putConstraint("East", (Component)settingElement_document, -10, "East", (Component)this);
        springLayout.putConstraint("South", (Component)settingElement_document, 29, "South", (Component)settingElement_delete_analytics);
        this.add((Component)settingElement_document);
        SettingElement settingElement_program_Java = new SettingElement("", programJava, 25, -1);
        springLayout.putConstraint("North", (Component)settingElement_program_Java, 10, "South", (Component)settingElement_document);
        springLayout.putConstraint("West", (Component)settingElement_program_Java, 185, "West", (Component)this);
        springLayout.putConstraint("East", (Component)settingElement_program_Java, -100, "East", (Component)this);
        springLayout.putConstraint("South", (Component)settingElement_program_Java, 35, "South", (Component)settingElement_document);
        this.add((Component)settingElement_program_Java);
        errorButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                errorButton.setBackground(new Color(255, 0, 0));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                errorButton.setBackground(backgroundOldButtonColor);
            }
        });
        errorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CompletableFuture.runAsync(() -> DesktopUtil.uncheckCall(() -> {
                    LocalizableLabel message = new LocalizableLabel("settings.servers.analytics.delete");
                    String editMessege = String.format(message.getText(), TLauncher.getInstance().getConfiguration().getClient().toString());
                    statisticsController.removeUserData();
                    Alert.showMessage("", Localizable.get().get(editMessege));
                    return null;
                })).exceptionally(t -> {
                    SwingUtilities.invokeLater(() -> Alert.showLocMessage("", "modpack.try.later", null));
                    U.log(t);
                    return null;
                });
            }
        });
        this.addHandler(new HandlerSettings("gui.statistics.checkbox", statistics));
        this.addHandler(new HandlerSettings("gui.settings.guard.checkbox", guard));
        this.addHandler(new HandlerSettings("gui.discord.checkbox", turnOffDiscord));
        this.addHandler(new HandlerSettings("gui.settings.servers.recommendation", recommendedServers));
        SwingUtil.changeFontFamily(this.documentText, FontTL.ROBOTO_REGULAR, 14);
        SwingUtil.changeFontFamily(this.html, FontTL.ROBOTO_REGULAR, 14, Color.BLACK);
        programJava.addActionListener(e -> {
            AboutApplicationFrame frame = (AboutApplicationFrame)TLauncher.getInjector().getInstance(AboutApplicationFrame.class);
            frame.setVisible(true);
        });
        this.documentText.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    String url = String.format("https://ad.tlauncher.org/link/privacy-policy-%s", TLauncher.getInstance().getConfiguration().isUSSRLocale() ? "ru" : "en");
                    OS.openLink(url);
                }
            }
        });
        questionLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    String url = String.format("https://tlauncher.org/%s/guard.html", TLauncher.getInstance().getConfiguration().isUSSRLocale() ? "ru" : "en");
                    OS.openLink(url);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                questionLabel.setIcon(ImageCache.getNativeIcon((String)"qestion-option-panel-blue.png"));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                questionLabel.setIcon(ImageCache.getNativeIcon((String)"qestion-option-panel.png"));
            }
        });
        ActionListener l = e -> {
            if (this.tlauncher.getProfileManager().isNotPremium()) {
                ((JCheckBox)e.getSource()).setSelected(true);
                Alert.showHtmlMessage("", Localizable.get("account.premium.not.available"), 1, 400);
            }
        };
        recommendedServers.addActionListener(l);
        guard.addActionListener(l);
    }

    public boolean chooseChinaLocal() {
        if (Objects.isNull(this.global.getLocale())) {
            return false;
        }
        return ((Locale)this.local.getSelectedValue()).getLanguage().equals(new Locale("zh").getLanguage()) || this.global.getLocale().getLanguage().equals(new Locale("zh").getLanguage());
    }

    private static <T> void setTLauncherBasicComboBoxUI(JComboBox<T> comboBox) {
        comboBox.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, new Color(149, 149, 149)));
        comboBox.setUI(new TlauncherBasicComboBoxUI(){

            @Override
            protected ComboPopup createPopup() {
                BasicComboPopup basic = new BasicComboPopup(this.comboBox){

                    @Override
                    protected JScrollPane createScroller() {
                        VersionScrollBarUI barUI = new VersionScrollBarUI(){

                            @Override
                            protected Dimension getMinimumThumbSize() {
                                return new Dimension(10, 40);
                            }

                            @Override
                            public Dimension getMaximumSize(JComponent c) {
                                Dimension dim = super.getMaximumSize(c);
                                dim.setSize(10.0, dim.getHeight());
                                return dim;
                            }

                            @Override
                            public Dimension getPreferredSize(JComponent c) {
                                Dimension dim = super.getPreferredSize(c);
                                dim.setSize(13.0, dim.getHeight());
                                return dim;
                            }
                        };
                        barUI.setGapThubm(5);
                        JScrollPane scroller = new JScrollPane(this.list, 20, 31);
                        scroller.getVerticalScrollBar().setUI(barUI);
                        return scroller;
                    }
                };
                basic.setBorder(BorderFactory.createMatteBorder(0, 1, 1, 1, Color.GRAY));
                return basic;
            }
        });
    }

    @Override
    public void init() {
        super.init();
        this.documentText.setText(Localizable.get("settings.servers.document"));
        this.html.setText(Localizable.get("settings.servers.analytics"));
    }
}

