/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.scenes;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.tlauncher.tlauncher.managers.ProfileManager;
import org.tlauncher.tlauncher.minecraft.auth.Account;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.MainPane;
import org.tlauncher.tlauncher.ui.accounts.AccountEditor;
import org.tlauncher.tlauncher.ui.accounts.AccountList;
import org.tlauncher.tlauncher.ui.accounts.AccountTip;
import org.tlauncher.tlauncher.ui.accounts.helper.AccountEditorHelper;
import org.tlauncher.tlauncher.ui.accounts.helper.HelperState;
import org.tlauncher.tlauncher.ui.images.ImageCache;
import org.tlauncher.tlauncher.ui.scenes.PseudoScene;
import org.tlauncher.tlauncher.ui.server.BackPanel;
import org.tlauncher.tlauncher.ui.swing.FlexibleEditorPanel;
import org.tlauncher.tlauncher.ui.swing.extended.ExtendedPanel;

public class AccountEditorScene
extends PseudoScene {
    private static final long serialVersionUID = -151325577614420989L;
    public final AccountEditor editor;
    public final AccountList list;
    public final AccountTip tip;
    public final AccountEditorHelper helper;
    public final JPanel base = new JPanel(new BorderLayout());
    public static final Color BACKGROUND_ACCOUNT_COLOR = new Color(248, 246, 244);
    private final FlexibleEditorPanel flex;
    private final ProfileManager profileManager;

    public AccountEditorScene(MainPane main) {
        super(main);
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.flex = new FlexibleEditorPanel("text/html", "auth.tip.tlauncher", 0);
        ExtendedPanel middlePanel = new ExtendedPanel();
        this.profileManager = TLauncher.getInstance().getProfileManager();
        BackPanel backPanel = new BackPanel("account.config", new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    AccountEditorScene.this.profileManager.refresh();
                    AccountEditorScene.this.getMainPane().openDefaultScene();
                }
            }
        }, ImageCache.getIcon((String)"back-arrow.png"));
        this.flex.setMargin(new Insets(10, 20, 20, 20));
        backPanel.setPreferredSize(new Dimension(1, 25));
        middlePanel.setLayout(new BoxLayout(middlePanel, 0));
        ExtendedPanel separator = new ExtendedPanel(new GridLayout());
        JPanel gap = new JPanel(new FlowLayout(1, 0, 0));
        gap.setPreferredSize(new Dimension(1, 0));
        gap.setBackground(new Color(172, 171, 170));
        gap.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 1));
        separator.setBorder(BorderFactory.createEmptyBorder(0, 40, 0, 40));
        ((Container)separator).add(gap);
        this.editor = new AccountEditor(this, this.flex);
        this.editor.setOpaque(true);
        this.list = new AccountList(this);
        this.profileManager.addListener(this.list);
        this.tip = new AccountTip(this);
        this.tip.setAccountType(Account.AccountType.TLAUNCHER);
        this.editor.setSelectedAccountType(Account.AccountType.TLAUNCHER);
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentShown(ComponentEvent e) {
                if (AccountEditorScene.this.list.model.getSize() == 0) {
                    AccountEditorScene.this.list.addTempToList();
                }
            }

            @Override
            public void componentResized(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
        this.tip.setVisible(true);
        this.helper = new AccountEditorHelper(this);
        this.helper.setState(HelperState.NONE);
        this.base.setOpaque(true);
        this.add((Component)this.base);
        this.base.add((Component)backPanel, "North");
        JPanel topPanel = new JPanel(gbl);
        topPanel.setBackground(Color.WHITE);
        this.base.add((Component)topPanel, "Center");
        this.base.add((Component)this.flex, "South");
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 1;
        topPanel.add((Component)this.editor, c);
        c.fill = 3;
        c.gridx = 1;
        topPanel.add((Component)separator, c);
        c.fill = 1;
        c.gridx = 2;
        topPanel.add((Component)this.list, c);
        topPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 0, 20));
        int max = Math.max(this.editor.getPreferredSize().width, this.list.getPreferredSize().width);
        int maxH = Math.max(this.editor.getPreferredSize().height, this.list.getPreferredSize().height) + 30;
        this.editor.setPreferredSize(new Dimension(max, maxH));
        this.list.setPreferredSize(new Dimension(max, maxH));
    }

    public void setShownAccountHelper(boolean shown, boolean animate) {
        super.setShown(shown, animate);
        if (!shown || !this.list.model.isEmpty()) {
            this.helper.setState(HelperState.NONE);
        }
    }

    @Override
    public void onResize() {
        super.onResize();
        int hw = this.getWidth() / 2;
        int hh = this.getHeight() / 2;
        this.base.setSize(this.base.getPreferredSize());
        this.base.setBackground(Color.WHITE);
        this.base.setLocation(hw - this.base.getPreferredSize().width / 2, hh - this.base.getPreferredSize().height / 2);
    }
}

