/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.modpack;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.SwingUtilities;
import org.tlauncher.modpack.domain.client.CommentDTO;
import org.tlauncher.tlauncher.controller.CommentModpackController;
import org.tlauncher.tlauncher.exceptions.RequiredTLAccountException;
import org.tlauncher.tlauncher.exceptions.SelectedAnyOneTLAccountException;
import org.tlauncher.tlauncher.ui.alert.Alert;
import org.tlauncher.tlauncher.ui.label.CheckBoxBlockAction;
import org.tlauncher.tlauncher.ui.loc.Localizable;
import org.tlauncher.tlauncher.ui.model.CurrentUserPosition;

public class UserPositionCommentCheckbox
extends CheckBoxBlockAction {
    private ButtonGroup buttonGroup;
    private boolean position;
    private CurrentUserPosition pos;
    private static final long serialVersionUID = 1L;
    private CommentModpackController controller;
    private CommentDTO comment;

    public UserPositionCommentCheckbox(String selectedIcon, String diselectedIcon, ButtonGroup buttonGroup, boolean position) {
        super(selectedIcon, diselectedIcon);
        this.buttonGroup = buttonGroup;
        this.position = position;
    }

    @Override
    public void executeRequest() {
        try {
            if (this.isSelected()) {
                this.controller.deletePosition(this.comment.getId());
                this.buttonGroup.clearSelection();
                this.pos.update(this.position, false);
            } else {
                this.controller.setPosition(this.position, this.comment.getId());
                this.pos.update(this.position, true);
            }
            SwingUtilities.invokeLater(() -> {
                Enumeration<AbstractButton> en = this.buttonGroup.getElements();
                while (en.hasMoreElements()) {
                    UserPositionCommentCheckbox u = (UserPositionCommentCheckbox)en.nextElement();
                    u.initCounterPosition();
                }
            });
        }
        catch (RequiredTLAccountException e) {
            Alert.showLocError("modpack.right.panel.required.tl.account.title", Localizable.get("modpack.right.panel.required.tl.account", Localizable.get("loginform.button.settings.account")), null);
        }
        catch (SelectedAnyOneTLAccountException e) {
            Alert.showLocError("modpack.right.panel.required.tl.account.title", "modpack.right.panel.select.account.tl", null);
        }
        catch (IOException e) {
            Alert.showLocMessage("modpack.remote.not.found", "modpack.try.later", null);
        }
    }

    public void initCounterPosition() {
        Long value;
        Long l = value = this.position ? this.comment.getGoodPosition() : this.comment.getBadPosition();
        if (Objects.isNull(value)) {
            value = 0L;
        }
        if (Objects.nonNull(this.comment.getAuthorPosition())) {
            if (this.comment.getAuthorPosition().isPosition() && this.position) {
                Long l2 = value;
                Long l3 = value = Long.valueOf(value - 1L);
            } else if (!this.comment.getAuthorPosition().isPosition() && !this.position) {
                Long l4 = value;
                Long l5 = value = Long.valueOf(value - 1L);
            }
        }
        if ((value = Long.valueOf(value + (long)this.pos.getByPosition(this.position))) >= 0L) {
            this.setText("" + value);
        } else {
            this.setText("0");
        }
    }

    public boolean isPosition() {
        return this.position;
    }

    public void setPos(CurrentUserPosition pos) {
        this.pos = pos;
    }

    public void setController(CommentModpackController controller) {
        this.controller = controller;
    }

    public void setComment(CommentDTO comment) {
        this.comment = comment;
    }
}

