/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.modpack;

import by.gdev.util.DesktopUtil;
import com.google.common.collect.Lists;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import net.minecraft.launcher.versions.CompleteVersion;
import org.tlauncher.modpack.domain.client.GameEntityDTO;
import org.tlauncher.modpack.domain.client.GameVersionDTO;
import org.tlauncher.modpack.domain.client.ModDTO;
import org.tlauncher.modpack.domain.client.share.GameType;
import org.tlauncher.modpack.domain.client.share.MinecraftVersionDTO;
import org.tlauncher.modpack.domain.client.share.NameIdDTO;
import org.tlauncher.modpack.domain.client.version.ModpackVersionDTO;
import org.tlauncher.tlauncher.configuration.Configuration;
import org.tlauncher.tlauncher.controller.ModpackConfig;
import org.tlauncher.tlauncher.managers.ModpackManager;
import org.tlauncher.tlauncher.modpack.ModpackUtil;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.alert.Alert;
import org.tlauncher.tlauncher.ui.editor.EditorCheckBox;
import org.tlauncher.tlauncher.ui.images.ImageCache;
import org.tlauncher.tlauncher.ui.loc.Localizable;
import org.tlauncher.tlauncher.ui.loc.LocalizableLabel;
import org.tlauncher.tlauncher.ui.loc.UpdaterFullButton;
import org.tlauncher.tlauncher.ui.modpack.SliderModpackPanel;
import org.tlauncher.tlauncher.ui.modpack.TemlateModpackFrame;
import org.tlauncher.tlauncher.ui.swing.renderer.CreationModpackForgeComboboxRenderer;
import org.tlauncher.tlauncher.ui.ui.CreationModpackForgeComboboxUI;
import org.tlauncher.util.ColorUtil;
import org.tlauncher.util.SwingUtil;
import org.tlauncher.util.U;
import org.tlauncher.util.swing.FontTL;

public class ModpackConfigFrame
extends TemlateModpackFrame {
    private ModpackConfig controller;
    private JCheckBox box;
    private JTextField modpackName;
    private JComboBox<MinecraftVersionDTO> minecraftVersion;
    private SliderModpackPanel slider;
    private JButton save;
    private JButton open;
    private JButton remove;
    private EditorCheckBox skinCheckBox;
    private static final Dimension maxSize = new Dimension(572, 451);
    private static final Dimension minSize = new Dimension(572, 350);
    private ModpackManager manager;
    private JPanel panel;
    private JLabel selectedMemory;
    private JLabel question;
    private Configuration c;
    private Color colorButton = new Color(0, 174, 239);

    public ModpackConfigFrame(JFrame parent, CompleteVersion version) {
        super(parent, "modpack.config.title", minSize);
        this.manager = (ModpackManager)TLauncher.getInjector().getInstance(ModpackManager.class);
        this.controller = (ModpackConfig)TLauncher.getInjector().getInstance(ModpackConfig.class);
        this.question = new JLabel(ImageCache.getNativeIcon((String)"qestion-option-panel.png"));
        this.c = TLauncher.getInstance().getConfiguration();
        this.question.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ModpackConfigFrame.this.setVisible(false);
                Alert.showLocMessage(ModpackConfigFrame.this.c.get("memory.problem.message"));
                ModpackConfigFrame.this.setVisible(true);
            }
        });
        LocalizableLabel memorySettings = new LocalizableLabel("modpack.config.memory.title");
        LocalizableLabel optifineLabel = new LocalizableLabel("modpack.config.system.label");
        Border empty = BorderFactory.createLineBorder(ColorUtil.COLOR_149, 1);
        CompoundBorder border = new CompoundBorder(empty, BorderFactory.createEmptyBorder(0, 15, 0, 0));
        LocalizableLabel nameLabel = new LocalizableLabel("modpack.creation.name");
        JLabel forgeVersionLabel = new JLabel(Localizable.get("version.name.v1") + ":");
        LocalizableLabel minecraftVersinoTypeLabel = new LocalizableLabel("version.manager.editor.field.type");
        LocalizableLabel gameVersion = new LocalizableLabel("modpack.config.game.version");
        minecraftVersinoTypeLabel.setVerticalAlignment(0);
        gameVersion.setVerticalAlignment(0);
        this.selectedMemory = new LocalizableLabel("settings.java.memory.label");
        ModpackVersionDTO modpackVersionDTO = (ModpackVersionDTO)version.getModpack().getVersion();
        GameVersionDTO gameVersionDTO = modpackVersionDTO.getGameVersionDTO();
        this.minecraftVersion = new JComboBox();
        this.minecraftVersion.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, ColorUtil.COLOR_149));
        this.minecraftVersion.setRenderer(new CreationModpackForgeComboboxRenderer());
        this.minecraftVersion.setUI(new CreationModpackForgeComboboxUI());
        this.box = new EditorCheckBox("modpack.config.memory.box");
        this.box.setIconTextGap(14);
        this.skinCheckBox = new EditorCheckBox("modpack.config.skin.use");
        this.skinCheckBox.setIconTextGap(14);
        if (ModpackUtil.useSkinMod(version)) {
            this.skinCheckBox.setSelected(true);
        } else if (gameVersionDTO == null) {
            this.skinCheckBox.setSelected(false);
            this.skinCheckBox.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    this.setVisible(false);
                    Alert.showLocMessage("modpack.internet.update");
                    this.skinCheckBox.setSelected(false);
                    this.setVisible(true);
                }
            });
        }
        this.modpackName = new JTextField(version.getID());
        this.modpackName.setBorder(border);
        this.modpackName.setForeground(ColorUtil.COLOR_25);
        JLabel gameVersionValue = new JLabel(modpackVersionDTO.getGameVersionDTO().getName());
        NameIdDTO mvt = modpackVersionDTO.findFirstMinecraftVersionType();
        LocalizableLabel minecraftVersionTypeValue = new LocalizableLabel("modpack.version." + (Objects.nonNull(mvt) ? mvt.getName() : "forge"));
        minecraftVersionTypeValue.setBorder(border);
        gameVersionValue.setBorder(border);
        this.slider = new SliderModpackPanel(new Dimension(534, 80));
        if (version.getModpack().isModpackMemory()) {
            this.slider.setValue(version.getModpack().getMemory());
        } else {
            this.slider.setValue(TLauncher.getInstance().getConfiguration().getInteger("minecraft.memory.ram2"));
        }
        this.save = new UpdaterFullButton(this.colorButton, BLUE_COLOR_UNDER, "settings.save", "save-modpack.png");
        this.save.setBorder(BorderFactory.createEmptyBorder(0, 14, 0, 0));
        this.save.setIconTextGap(19);
        this.open = new UpdaterFullButton(this.colorButton, BLUE_COLOR_UNDER, "modpack.open.folder", "open-modpack.png");
        this.open.setIconTextGap(10);
        this.remove = new UpdaterFullButton(new Color(208, 43, 43), new Color(180, 39, 39), "modpack.popup.delete", "modpack-dustbin.png");
        this.remove.setBorder(BorderFactory.createEmptyBorder(0, 19, 0, 0));
        this.remove.setIconTextGap(15);
        SpringLayout spring = new SpringLayout();
        this.panel = new JPanel(spring);
        this.panel.setBackground(Color.WHITE);
        this.panel.setBorder(BorderFactory.createEmptyBorder(20, 0, 21, 0));
        this.addCenter(this.panel);
        SwingUtil.changeFontFamily(nameLabel, FontTL.ROBOTO_REGULAR, 14, ColorUtil.COLOR_149);
        SwingUtil.changeFontFamily(gameVersion, FontTL.ROBOTO_REGULAR, 14, ColorUtil.COLOR_149);
        SwingUtil.changeFontFamily(minecraftVersinoTypeLabel, FontTL.ROBOTO_REGULAR, 14, ColorUtil.COLOR_149);
        SwingUtil.changeFontFamily(gameVersionValue, FontTL.ROBOTO_REGULAR, 16, ColorUtil.COLOR_149);
        SwingUtil.changeFontFamily(minecraftVersionTypeValue, FontTL.ROBOTO_REGULAR, 16, ColorUtil.COLOR_149);
        SwingUtil.changeFontFamily(this.modpackName, FontTL.ROBOTO_REGULAR, 16, ColorUtil.COLOR_25);
        SwingUtil.changeFontFamily(forgeVersionLabel, FontTL.ROBOTO_REGULAR, 14, ColorUtil.COLOR_149);
        SwingUtil.changeFontFamily(this.minecraftVersion, FontTL.ROBOTO_REGULAR, 16, ColorUtil.COLOR_149);
        SwingUtil.changeFontFamily(this.box, FontTL.ROBOTO_REGULAR, 14, Color.BLACK);
        SwingUtil.changeFontFamily(this.skinCheckBox, FontTL.ROBOTO_REGULAR, 14, Color.BLACK);
        SwingUtil.changeFontFamily(memorySettings, FontTL.ROBOTO_BOLD, 14, Color.BLACK);
        SwingUtil.changeFontFamily(optifineLabel, FontTL.ROBOTO_BOLD, 14, Color.BLACK);
        SwingUtil.changeFontFamily(this.selectedMemory, FontTL.ROBOTO_BOLD, 14, Color.BLACK);
        SwingUtil.changeFontFamily(this.save, FontTL.ROBOTO_REGULAR, 12, Color.WHITE);
        SwingUtil.changeFontFamily(this.open, FontTL.ROBOTO_REGULAR, 12, Color.WHITE);
        SwingUtil.changeFontFamily(this.remove, FontTL.ROBOTO_REGULAR, 12, Color.WHITE);
        spring.putConstraint("West", (Component)nameLabel, 30, "West", (Component)this.panel);
        spring.putConstraint("East", (Component)nameLabel, 267, "West", (Component)this.panel);
        spring.putConstraint("North", (Component)nameLabel, -3, "North", (Component)this.panel);
        spring.putConstraint("South", (Component)nameLabel, 15, "North", (Component)this.panel);
        this.panel.add(nameLabel);
        spring.putConstraint("West", (Component)this.modpackName, 29, "West", (Component)this.panel);
        spring.putConstraint("East", (Component)this.modpackName, -27, "East", (Component)this.panel);
        spring.putConstraint("North", (Component)this.modpackName, 19, "North", (Component)this.panel);
        spring.putConstraint("South", (Component)this.modpackName, 63, "North", (Component)this.panel);
        this.panel.add(this.modpackName);
        spring.putConstraint("West", (Component)minecraftVersinoTypeLabel, 32, "West", (Component)this.panel);
        spring.putConstraint("East", (Component)minecraftVersinoTypeLabel, 139, "West", (Component)this.panel);
        spring.putConstraint("North", (Component)minecraftVersinoTypeLabel, 10, "South", (Component)this.modpackName);
        spring.putConstraint("South", (Component)minecraftVersinoTypeLabel, 28, "South", (Component)this.modpackName);
        this.panel.add(minecraftVersinoTypeLabel);
        spring.putConstraint("West", (Component)gameVersion, 162, "West", (Component)this.panel);
        spring.putConstraint("East", (Component)gameVersion, 289, "West", (Component)this.panel);
        spring.putConstraint("North", (Component)gameVersion, 10, "South", (Component)this.modpackName);
        spring.putConstraint("South", (Component)gameVersion, 28, "South", (Component)this.modpackName);
        this.panel.add(gameVersion);
        spring.putConstraint("West", (Component)forgeVersionLabel, 332, "West", (Component)this.panel);
        spring.putConstraint("East", (Component)forgeVersionLabel, -27, "East", (Component)this.panel);
        spring.putConstraint("North", (Component)forgeVersionLabel, 10, "South", (Component)this.modpackName);
        spring.putConstraint("South", (Component)forgeVersionLabel, 28, "South", (Component)this.modpackName);
        this.panel.add(forgeVersionLabel);
        spring.putConstraint("West", (Component)minecraftVersionTypeValue, 29, "West", (Component)this.panel);
        spring.putConstraint("East", (Component)minecraftVersionTypeValue, 139, "West", (Component)this.panel);
        spring.putConstraint("North", (Component)minecraftVersionTypeValue, 4, "South", (Component)gameVersion);
        spring.putConstraint("South", (Component)minecraftVersionTypeValue, 48, "South", (Component)gameVersion);
        this.panel.add(minecraftVersionTypeValue);
        spring.putConstraint("West", (Component)gameVersionValue, 159, "West", (Component)this.panel);
        spring.putConstraint("East", (Component)gameVersionValue, 309, "West", (Component)this.panel);
        spring.putConstraint("North", (Component)gameVersionValue, 4, "South", (Component)gameVersion);
        spring.putConstraint("South", (Component)gameVersionValue, 48, "South", (Component)gameVersion);
        this.panel.add(gameVersionValue);
        spring.putConstraint("West", this.minecraftVersion, 329, "West", (Component)this.panel);
        spring.putConstraint("East", this.minecraftVersion, -27, "East", (Component)this.panel);
        spring.putConstraint("North", this.minecraftVersion, 4, "South", (Component)forgeVersionLabel);
        spring.putConstraint("South", this.minecraftVersion, 48, "South", (Component)forgeVersionLabel);
        this.panel.add(this.minecraftVersion);
        spring.putConstraint("West", (Component)optifineLabel, 29, "West", (Component)this.panel);
        spring.putConstraint("East", (Component)optifineLabel, 169, "East", (Component)this.panel);
        spring.putConstraint("North", (Component)optifineLabel, 15, "South", this.minecraftVersion);
        spring.putConstraint("South", (Component)optifineLabel, 33, "South", this.minecraftVersion);
        this.panel.add(optifineLabel);
        spring.putConstraint("West", (Component)this.skinCheckBox, 179, "West", (Component)this.panel);
        spring.putConstraint("East", (Component)this.skinCheckBox, -27, "East", (Component)this.panel);
        spring.putConstraint("North", (Component)this.skinCheckBox, 15, "South", this.minecraftVersion);
        spring.putConstraint("South", (Component)this.skinCheckBox, 33, "South", this.minecraftVersion);
        this.panel.add(this.skinCheckBox);
        spring.putConstraint("West", (Component)memorySettings, 29, "West", (Component)this.panel);
        spring.putConstraint("East", (Component)memorySettings, 169, "East", (Component)this.panel);
        spring.putConstraint("North", (Component)memorySettings, 10, "South", (Component)this.skinCheckBox);
        spring.putConstraint("South", (Component)memorySettings, 33, "South", (Component)this.skinCheckBox);
        this.panel.add(memorySettings);
        spring.putConstraint("West", (Component)this.box, 179, "West", (Component)this.panel);
        spring.putConstraint("East", (Component)this.box, -27, "East", (Component)this.panel);
        spring.putConstraint("North", (Component)this.box, 10, "South", (Component)this.skinCheckBox);
        spring.putConstraint("South", (Component)this.box, 33, "South", (Component)this.skinCheckBox);
        this.panel.add(this.box);
        spring.putConstraint("West", (Component)this.save, 29, "West", (Component)this.panel);
        spring.putConstraint("East", (Component)this.save, 168, "West", (Component)this.panel);
        spring.putConstraint("North", (Component)this.save, -43, "South", (Component)this.panel);
        spring.putConstraint("South", (Component)this.save, 0, "South", (Component)this.panel);
        this.panel.add(this.save);
        spring.putConstraint("West", (Component)this.open, 185, "West", (Component)this.panel);
        spring.putConstraint("East", (Component)this.open, 390, "West", (Component)this.panel);
        spring.putConstraint("North", (Component)this.open, -43, "South", (Component)this.panel);
        spring.putConstraint("South", (Component)this.open, 0, "South", (Component)this.panel);
        this.panel.add(this.open);
        spring.putConstraint("West", (Component)this.remove, 406, "West", (Component)this.panel);
        spring.putConstraint("East", (Component)this.remove, -27, "East", (Component)this.panel);
        spring.putConstraint("North", (Component)this.remove, -43, "South", (Component)this.panel);
        spring.putConstraint("South", (Component)this.remove, 0, "South", (Component)this.panel);
        this.panel.add(this.remove);
        this.box.addItemListener(e -> this.updateState(spring));
        this.box.setSelected(!version.getModpack().isModpackMemory());
        this.save.addActionListener(e -> {
            if (!this.box.isSelected()) {
                version.getModpack().setMemory(this.slider.getValue());
            }
            version.getModpack().setModpackMemory(!this.box.isSelected());
            this.controller.save(version, this.modpackName.getText(), this.skinCheckBox.isSelected(), ((MinecraftVersionDTO)this.minecraftVersion.getSelectedItem()).createFromCurrent());
            this.setVisible(false);
        });
        this.open.addActionListener(e -> {
            this.controller.open(version);
            this.setVisible(false);
        });
        this.remove.addActionListener(e -> {
            if (Alert.showLocQuestion("skin.notification.title", "modpack.config.editor.delete")) {
                this.controller.remove(version);
                this.setVisible(false);
            }
        });
        this.updateState(spring);
        this.addedVersions(modpackVersionDTO);
    }

    private void addedVersions(ModpackVersionDTO mv) {
        CompletableFuture.runAsync(() -> DesktopUtil.uncheckCall(() -> {
            GameVersionDTO gv = this.manager.getGameVersion(mv);
            List<MinecraftVersionDTO> fv = this.manager.getVersionsByGameVersionAndMinecraftVersionType(gv.getId(), mv.findFirstMinecraftVersionType());
            this.minecraftVersion.setModel(new DefaultComboBoxModel<MinecraftVersionDTO>(fv.toArray(new MinecraftVersionDTO[0])));
            fv.stream().filter(f -> f.getId().equals(mv.getMinecraftVersionName().getId())).findAny().ifPresent(f -> this.minecraftVersion.setSelectedItem(f));
            return null;
        })).exceptionally(e -> {
            MinecraftVersionDTO f = new MinecraftVersionDTO();
            f.setName(mv.getMinecraftVersionName().getName());
            this.minecraftVersion.setModel(new DefaultComboBoxModel<MinecraftVersionDTO>(Lists.newArrayList((Object[])new MinecraftVersionDTO[]{f}).toArray(new MinecraftVersionDTO[0])));
            return null;
        });
        CompletableFuture.runAsync(() -> DesktopUtil.uncheckCall(() -> {
            this.updateSkinBoxButton(this.manager.getGameVersion(mv), mv);
            return null;
        }));
    }

    private void updateState(SpringLayout spring) {
        if (this.box.isSelected()) {
            this.panel.remove(this.selectedMemory);
            this.panel.remove(this.slider);
            this.panel.remove(this.question);
            this.setCenter(minSize);
        } else {
            spring.putConstraint("West", (Component)this.slider, 12, "West", (Component)this.panel);
            spring.putConstraint("East", (Component)this.slider, -13, "East", (Component)this.panel);
            spring.putConstraint("North", (Component)this.slider, -130, "South", (Component)this.panel);
            spring.putConstraint("South", (Component)this.slider, -60, "South", (Component)this.panel);
            this.panel.add(this.slider);
            spring.putConstraint("West", (Component)this.selectedMemory, 29, "West", (Component)this.panel);
            spring.putConstraint("East", (Component)this.selectedMemory, 29 + SwingUtil.getWidthText(this.selectedMemory, this.selectedMemory.getText()) + 5, "West", (Component)this.panel);
            spring.putConstraint("North", (Component)this.selectedMemory, -150, "South", (Component)this.panel);
            spring.putConstraint("South", (Component)this.selectedMemory, -132, "South", (Component)this.panel);
            this.panel.add(this.selectedMemory);
            spring.putConstraint("West", (Component)this.question, 2, "East", (Component)this.selectedMemory);
            spring.putConstraint("East", (Component)this.question, 25, "East", (Component)this.selectedMemory);
            spring.putConstraint("North", (Component)this.question, -151, "South", (Component)this.panel);
            spring.putConstraint("South", (Component)this.question, -131, "South", (Component)this.panel);
            this.panel.add(this.question);
            this.setCenter(maxSize);
            if (!this.c.isExist("memory.problem.message")) {
                this.question.setVisible(false);
            }
        }
        this.panel.revalidate();
        this.panel.repaint();
    }

    private void updateSkinBoxButton(GameVersionDTO gameVersionDTO, ModpackVersionDTO mv) {
        if (this.skinCheckBox.isSelected()) {
            return;
        }
        SwingUtilities.invokeLater(() -> this.skinCheckBox.setEnabled(false));
        GameEntityDTO g = new GameEntityDTO();
        g.setId(ModDTO.TL_SKIN_CAPE_ID);
        try {
            this.manager.getInstallingGameEntity(GameType.MOD, g, null, gameVersionDTO, mv.findFirstMinecraftVersionType());
            SwingUtilities.invokeLater(() -> this.skinCheckBox.setEnabled(true));
        }
        catch (IOException e) {
            U.log("not found tl skin cape for", gameVersionDTO.getName(), mv.findFirstMinecraftVersionType());
        }
    }
}

