/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.modpack;

import by.gdev.util.DesktopUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.CompletableFuture;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.tlauncher.modpack.domain.client.share.GameType;
import org.tlauncher.modpack.domain.client.share.ParsedElementDTO;
import org.tlauncher.tlauncher.managers.ModpackManager;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.alert.Alert;
import org.tlauncher.tlauncher.ui.loc.Localizable;
import org.tlauncher.tlauncher.ui.loc.UpdaterButton;
import org.tlauncher.tlauncher.ui.modpack.AddedModpackStuffFrame;
import org.tlauncher.util.U;

public class AddedButtonOldVersion
extends AddedModpackStuffFrame {
    protected final UpdaterButton oldAdditionButton;
    protected final ModpackManager manager;
    private static final long serialVersionUID = 5115926326682859514L;
    private String dateTimeFormat = "dd.MM.YYYY HH:MM:ss";

    public AddedButtonOldVersion(JFrame parent, String title, String message1, final Long id, final GameType type) {
        super(parent, title, message1);
        final Color backgroundOldButtonColor = new Color(213, 213, 213);
        this.oldAdditionButton = new UpdaterButton(backgroundOldButtonColor, "explorer.button.update");
        this.manager = (ModpackManager)TLauncher.getInjector().getInstance(ModpackManager.class);
        this.spring.putConstraint("South", (Component)this.oldAdditionButton, 150, "North", (Component)this.message);
        this.spring.putConstraint("West", (Component)this.oldAdditionButton, 250, "West", (Component)this.panel);
        this.panel.add(this.oldAdditionButton);
        this.oldAdditionButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                AddedButtonOldVersion.this.oldAdditionButton.setBackground(new Color(160, 160, 160));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                AddedButtonOldVersion.this.oldAdditionButton.setBackground(backgroundOldButtonColor);
            }
        });
        this.oldAdditionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CompletableFuture.runAsync(() -> DesktopUtil.uncheckCall(() -> {
                    ParsedElementDTO pe = AddedButtonOldVersion.this.manager.labelForParsingGameEntity(id, type);
                    AddedButtonOldVersion.this.setVisible(false);
                    if (!pe.isParse()) {
                        LocalDateTime updated = LocalDateTime.ofInstant(Instant.ofEpochMilli(pe.getUpdated()), ZoneId.systemDefault());
                        LocalDateTime nextUpdated = LocalDateTime.ofInstant(Instant.ofEpochMilli(pe.getNextUpdated()), ZoneId.systemDefault());
                        Alert.showMessage(Localizable.get("version.manager.downloader.info.title"), Localizable.get("modpack.next.update", updated.format(DateTimeFormatter.ofPattern(AddedButtonOldVersion.this.dateTimeFormat)), nextUpdated.format(DateTimeFormatter.ofPattern(AddedButtonOldVersion.this.dateTimeFormat))));
                    }
                    return null;
                })).exceptionally(t -> {
                    SwingUtilities.invokeLater(() -> {
                        if (t.getMessage().contains("code 429 phrase")) {
                            Alert.showLocWarning("modpack.added.request.limit");
                        } else {
                            Alert.showLocMessage("", "modpack.try.later", null);
                        }
                    });
                    U.log(t);
                    return null;
                });
            }
        });
    }
}

