/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.login;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.List;
import javax.swing.SwingUtilities;
import net.minecraft.launcher.updater.VersionSyncInfo;
import net.minecraft.launcher.versions.CompleteVersion;
import org.tlauncher.modpack.domain.client.GameEntityDTO;
import org.tlauncher.modpack.domain.client.share.GameType;
import org.tlauncher.modpack.domain.client.version.VersionDTO;
import org.tlauncher.tlauncher.listeners.auth.LoginProcessListener;
import org.tlauncher.tlauncher.managers.VersionManager;
import org.tlauncher.tlauncher.managers.VersionManagerListener;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.alert.Alert;
import org.tlauncher.tlauncher.ui.block.Blockable;
import org.tlauncher.tlauncher.ui.listener.mods.GameEntityListener;
import org.tlauncher.tlauncher.ui.loc.LocalizableComponent;
import org.tlauncher.tlauncher.ui.login.LoginException;
import org.tlauncher.tlauncher.ui.login.LoginForm;
import org.tlauncher.tlauncher.ui.login.LoginWaitException;
import org.tlauncher.tlauncher.ui.swing.SimpleComboBoxModel;
import org.tlauncher.tlauncher.ui.swing.VersionCellRenderer;
import org.tlauncher.tlauncher.ui.swing.extended.ExtendedComboBox;

public class VersionComboBox
extends ExtendedComboBox<VersionSyncInfo>
implements Blockable,
VersionManagerListener,
LocalizableComponent,
LoginProcessListener,
GameEntityListener,
ItemListener {
    private static final long serialVersionUID = -9122074452728842733L;
    public static final VersionSyncInfo LOADING = VersionCellRenderer.LOADING;
    public static final VersionSyncInfo EMPTY = VersionCellRenderer.EMPTY;
    private final VersionManager manager;
    private final LoginForm loginForm;
    private final SimpleComboBoxModel<VersionSyncInfo> model = this.getSimpleModel();
    private String selectedVersion;

    VersionComboBox(LoginForm lf) {
        super(new VersionCellRenderer(){

            @Override
            public boolean getShowTLauncherVersions() {
                return false;
            }
        });
        this.loginForm = lf;
        this.manager = TLauncher.getInstance().getVersionManager();
        this.manager.addListener(this);
        this.addItemListener(e -> {
            this.loginForm.play.updateState();
            VersionSyncInfo selected = this.getVersion();
            if (selected != null) {
                this.selectedVersion = selected.getID();
            }
        });
        this.selectedVersion = lf.global.get("login.version.game");
    }

    public VersionSyncInfo getVersion() {
        VersionSyncInfo selected = (VersionSyncInfo)this.getSelectedItem();
        return selected == null || selected.equals(LOADING) || selected.equals(EMPTY) ? null : selected;
    }

    @Override
    public void validatePreGameLaunch() throws LoginException {
        VersionSyncInfo selected = this.getVersion();
        if (selected == null) {
            throw new LoginWaitException("Version list is empty, refreshing", () -> {
                this.manager.refresh();
                if (this.getVersion() == null) {
                    Alert.showLocError("versions.notfound");
                }
                throw new LoginException("Giving user a second chance to choose correct version...");
            });
        }
        TLauncher.getInstance().getConfiguration().setForcefully("login.version.game", selected.getID(), false);
        if (!selected.hasRemote() || !selected.isInstalled() || selected.isUpToDate()) {
            return;
        }
        if (!Alert.showLocQuestion("versions.found-update")) {
            try {
                CompleteVersion complete = this.manager.getLocalList().getCompleteVersion(selected.getLocal());
                complete.setUpdatedTime(selected.getLatestVersion().getUpdatedTime());
                this.manager.getLocalList().saveVersion(complete);
            }
            catch (IOException e) {
                Alert.showLocError("versions.found-update.error");
            }
            return;
        }
        this.loginForm.versionPanel.forceupdate.setSelected(true);
    }

    @Override
    public void updateLocale() {
        this.updateList(this.manager.getVersions(), null);
    }

    @Override
    public void onVersionsRefreshing(VersionManager vm) {
        this.updateList(null, null);
    }

    @Override
    public void onVersionsRefreshingFailed(VersionManager vm) {
        this.updateList(this.manager.getVersions(), null);
    }

    @Override
    public void onVersionsRefreshed(VersionManager vm) {
        this.updateList(this.manager.getVersions(), null);
    }

    void updateList(List<VersionSyncInfo> list, String select) {
        SwingUtilities.invokeLater(() -> {
            String select1 = select;
            if (select == null && this.selectedVersion != null) {
                select1 = this.selectedVersion;
            }
            this.removeAllItems();
            if (list == null) {
                this.addItem(LOADING);
                return;
            }
            if (list.isEmpty()) {
                this.addItem(EMPTY);
            } else {
                this.model.addElements(list);
                for (VersionSyncInfo version : list) {
                    if (select1 == null || !version.getID().equals(select1)) continue;
                    this.setSelectedItem(version);
                }
            }
        });
    }

    @Override
    public void block(Object reason) {
        this.setEnabled(false);
    }

    @Override
    public void unblock(Object reason) {
        this.setEnabled(true);
    }

    @Override
    public void activationStarted(GameEntityDTO e) {
    }

    @Override
    public void activation(GameEntityDTO e) {
    }

    @Override
    public void activationError(GameEntityDTO e, Throwable t) {
    }

    @Override
    public void processingStarted(GameEntityDTO e, VersionDTO version) {
    }

    @Override
    public void installEntity(GameEntityDTO e, GameType type) {
    }

    @Override
    public void installEntity(CompleteVersion e) {
        VersionSyncInfo versionSyncInfo = new VersionSyncInfo(e, null);
        this.model.insertElementAt(versionSyncInfo, 0);
        this.model.setSelectedItem(versionSyncInfo);
    }

    @Override
    public void removeEntity(GameEntityDTO e) {
        SwingUtilities.invokeLater(this::repaint);
    }

    @Override
    public void removeCompleteVersion(CompleteVersion e) {
        for (int i = 0; i < this.model.getSize(); ++i) {
            if (this.model.getElementAt(i).getLocal() == null || !this.model.getElementAt(i).getLocal().getID().equals(e.getID())) continue;
            this.model.removeElementAt(i);
            break;
        }
    }

    @Override
    public void installError(GameEntityDTO e, VersionDTO v, Throwable t) {
    }

    @Override
    public void populateStatus(GameEntityDTO status, GameType type, boolean state) {
    }

    @Override
    public void updateVersion(CompleteVersion old, CompleteVersion newVersion) {
        for (int i = 0; i < this.model.getSize(); ++i) {
            VersionSyncInfo versionSyncInfo = this.model.getElementAt(i);
            if (versionSyncInfo.getLocal() == null || !versionSyncInfo.getLocal().getID().equals(old.getID())) continue;
            versionSyncInfo.setLocal(newVersion);
            this.repaint();
            break;
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.revalidate();
        this.repaint();
    }
}

