/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.loc.modpack;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import net.minecraft.launcher.versions.CompleteVersion;
import org.tlauncher.modpack.domain.client.GameEntityDTO;
import org.tlauncher.modpack.domain.client.GameVersionDTO;
import org.tlauncher.modpack.domain.client.share.GameType;
import org.tlauncher.modpack.domain.client.version.ModpackVersionDTO;
import org.tlauncher.modpack.domain.client.version.VersionDTO;
import org.tlauncher.tlauncher.managers.ModpackManager;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.alert.Alert;
import org.tlauncher.tlauncher.ui.loc.modpack.TableActButton;
import org.tlauncher.tlauncher.ui.swing.box.ModpackComboBox;
import org.tlauncher.util.U;

public class ModpackTableInstallButton
extends TableActButton {
    private VersionDTO selectedVersion;
    private ModpackManager manager = (ModpackManager)TLauncher.getInjector().getInstance(ModpackManager.class);

    public ModpackTableInstallButton(GameEntityDTO entity, final GameType type, ModpackComboBox localmodpacks) {
        super(entity, type, localmodpacks);
        this.installButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModpackTableInstallButton.this.manager.installEntity(ModpackTableInstallButton.this.getEntity(), ModpackTableInstallButton.this.selectedVersion, type, true);
            }
        });
        this.removeButton.addActionListener(e -> this.manager.removeEntity(entity, this.selectedVersion, type));
        this.deniedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Alert.showLocMessageWithoutTitle("modpack.table.denied.button");
            }
        });
    }

    @Override
    public void initButton() {
        for (GameEntityDTO gameEntityDTO : this.getSelectedModpackData()) {
            if (!this.entity.getId().equals(gameEntityDTO.getId())) continue;
            this.selectedVersion = gameEntityDTO.getVersion();
            this.setTypeButton("REMOVE");
            return;
        }
        if (!GameType.MODPACK.equals((Object)this.type)) {
            if (this.localmodpacks.getSelectedIndex() > 0) {
                ModpackVersionDTO modpackVersionDTO = (ModpackVersionDTO)((CompleteVersion)this.localmodpacks.getSelectedItem()).getModpack().getVersion();
                try {
                    GameVersionDTO gameVersionDTO = this.manager.getGameVersion(modpackVersionDTO);
                    if (this.entity.getVersion().getGameVersionsDTO().contains(gameVersionDTO)) {
                        this.setTypeButton("INSTALL");
                        return;
                    }
                }
                catch (IOException e1) {
                    U.log(e1);
                }
            }
            this.setTypeButton("DENIED");
        } else {
            this.setTypeButton("INSTALL");
        }
    }
}

