/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.editor;

import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.util.regex.Pattern;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.block.Blocker;
import org.tlauncher.tlauncher.ui.editor.EditorField;
import org.tlauncher.tlauncher.ui.editor.EditorTextField;
import org.tlauncher.tlauncher.ui.explorer.FileChooser;
import org.tlauncher.tlauncher.ui.loc.LocalizableButton;
import org.tlauncher.tlauncher.ui.loc.UpdaterButton;
import org.tlauncher.tlauncher.ui.swing.extended.BorderPanel;
import org.tlauncher.util.U;

public class EditorFileField
extends BorderPanel
implements EditorField {
    private static final long serialVersionUID = 5136327098130653756L;
    public static final char DEFAULT_DELIMITER = ';';
    private final EditorTextField textField;
    private final LocalizableButton explorerButton;
    private final FileChooser explorer;
    private final char delimiterChar;
    private final Pattern delimiterSplitter;

    public EditorFileField(String prompt, boolean canBeEmpty, String button, FileChooser chooser, char delimiter) {
        super(10, 0);
        if (chooser == null) {
            throw new NullPointerException("FileExplorer should be defined!");
        }
        this.textField = new EditorTextField(prompt, canBeEmpty);
        this.explorerButton = new UpdaterButton(UpdaterButton.GRAY_COLOR, new Color(146, 147, 143), button);
        this.explorer = chooser;
        this.delimiterChar = delimiter;
        this.delimiterSplitter = Pattern.compile(String.valueOf(this.delimiterChar), 16);
        this.explorerButton.addActionListener(e -> {
            this.explorerButton.setEnabled(false);
            this.explorer.setCurrentDirectory(this.getFirstFile());
            int result = this.explorer.showDialog(this);
            if (result == 0) {
                this.setRawValue(this.explorer.getSelectedFiles());
            }
            this.explorerButton.setEnabled(true);
        });
        this.textField.setBackground(Color.WHITE);
        this.explorerButton.setBackground(Color.WHITE);
        this.setBackground(Color.WHITE);
        this.add((Component)this.textField, "Center");
        this.add((Component)this.explorerButton, "East");
    }

    public EditorFileField(String prompt, boolean canBeEmpty, FileChooser chooser) {
        this(prompt, canBeEmpty, "explorer.browse", chooser, ';');
    }

    public EditorFileField(String prompt, FileChooser chooser) {
        this(prompt, false, chooser);
    }

    @Override
    public String getSettingsValue() {
        return this.getValueFromRaw(this.getRawValues());
    }

    private File[] getRawValues() {
        String[] paths = this.getRawSplitValue();
        if (paths == null) {
            return null;
        }
        int len = paths.length;
        File[] files = new File[len];
        for (int i = 0; i < paths.length; ++i) {
            files[i] = new File(paths[i]);
        }
        return files;
    }

    @Override
    public void setSettingsValue(String value) {
        this.textField.setSettingsValue(value);
    }

    private void setRawValue(File[] fileList) {
        this.setSettingsValue(this.getValueFromRaw(fileList));
    }

    private String[] getRawSplitValue() {
        return this.splitString(this.textField.getValue());
    }

    private String getValueFromRaw(File[] files) {
        if (files == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (File file : files) {
            String path = file.getAbsolutePath();
            builder.append(this.delimiterChar).append(path);
        }
        return builder.substring(1);
    }

    private String[] splitString(String s) {
        if (s == null) {
            return null;
        }
        String[] split = this.delimiterSplitter.split(s);
        if (split.length == 0) {
            return null;
        }
        return split;
    }

    private File getFirstFile() {
        File[] files = this.getRawValues();
        if (files == null || files.length == 0) {
            return TLauncher.getDirectory();
        }
        return files[0];
    }

    @Override
    public boolean isValueValid() {
        return this.textField.isValueValid();
    }

    @Override
    public void setBackground(Color bg) {
        if (this.textField != null) {
            this.textField.setBackground(bg);
        }
    }

    @Override
    public void block(Object reason) {
        Blocker.blockComponents(reason, this.textField, this.explorerButton);
    }

    @Override
    public void unblock(Object reason) {
        Blocker.unblockComponents(Blocker.UNIVERSAL_UNBLOCK, this.textField, this.explorerButton);
    }

    protected void log(Object ... w) {
        U.log("[" + this.getClass().getSimpleName() + "]", w);
    }
}

