/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.console;

import com.google.inject.Singleton;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.SwingUtilities;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.WriterAppender;
import org.tlauncher.tlauncher.configuration.Configuration;
import org.tlauncher.tlauncher.configuration.enums.ConsoleType;
import org.tlauncher.tlauncher.minecraft.launcher.MinecraftLauncher;
import org.tlauncher.tlauncher.ui.alert.Alert;
import org.tlauncher.tlauncher.ui.console.ConsoleFrame;
import org.tlauncher.tlauncher.ui.swing.extended.ExtendedComponentAdapter;
import org.tlauncher.util.OS;
import org.tlauncher.util.TlauncherUtil;
import org.tlauncher.util.U;
import org.tlauncher.util.async.AsyncThread;
import org.tlauncher.util.pastebin.Paste;
import org.tlauncher.util.pastebin.PasteResult;

@Singleton
public class Console
extends WriterAppender {
    private ConsoleFrame frame;
    private Configuration global;
    private boolean killed;
    private volatile MinecraftLauncher launcher;

    public void init(final Configuration global, boolean show) {
        this.global = global;
        this.frame = new ConsoleFrame(this);
        this.update();
        this.updateLocale();
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Console.this.setShown(false);
                global.set("gui.console", (Object)ConsoleType.NONE);
            }

            @Override
            public void windowClosed(WindowEvent e) {
                U.log("Console", Console.this.name, "has been disposed.");
            }
        });
        this.frame.addComponentListener(new ExtendedComponentAdapter(this.frame){

            @Override
            public void componentShown(ComponentEvent e) {
                Console.this.save(true);
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                Console.this.save(true);
            }

            @Override
            public void onComponentResized(ComponentEvent e) {
                Console.this.save(true);
            }

            @Override
            public void onComponentMoved(ComponentEvent e) {
                Console.this.save(true);
            }
        });
        this.frame.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                Console.this.save(false);
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                Console.this.save(false);
            }

            @Override
            public void componentShown(ComponentEvent e) {
                Console.this.save(true);
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                Console.this.save(true);
            }
        });
        this.activateOptions();
        if (show) {
            this.show();
        }
    }

    void update() {
        this.check();
        if (this.global == null) {
            return;
        }
        String prefix = "gui.console.";
        int width = this.global.getInteger(prefix + "width", 670);
        int height = this.global.getInteger(prefix + "height", 500);
        int x = this.global.getInteger(prefix + "x", 0);
        int y = this.global.getInteger(prefix + "y", 0);
        this.frame.setSize(width, height);
        this.frame.setLocation(x, y);
    }

    void save() {
        this.save(false);
    }

    void save(boolean flush) {
        this.check();
        if (this.global == null) {
            return;
        }
        String prefix = "gui.console.";
        int[] size = this.getSize();
        int[] position = this.getPosition();
        this.global.set(prefix + "width", size[0], false);
        this.global.set(prefix + "height", size[1], false);
        this.global.set(prefix + "x", position[0], false);
        this.global.set(prefix + "y", position[1], false);
    }

    private void check() {
        if (this.killed) {
            throw new IllegalStateException("Console is already killed!");
        }
    }

    public void setShown(boolean shown) {
        if (shown) {
            this.show();
        } else {
            this.hide();
        }
    }

    public void show() {
        this.show(true);
    }

    public void show(boolean toFront) {
        SwingUtilities.invokeLater(() -> {
            if (!this.frame.isVisible()) {
                this.check();
                Logger.getRootLogger().addAppender(this);
                this.frame.setVisible(true);
                this.frame.print(U.readFileLog());
                this.frame.scrollDown();
            }
            if (toFront) {
                this.frame.toFront();
            }
        });
    }

    public void hide() {
        this.check();
        this.frame.setVisible(false);
        Logger.getRootLogger().removeAppender(this);
        this.frame.clear();
    }

    public void clear() {
        this.check();
        this.frame.clear();
    }

    public void sendPaste() {
        AsyncThread.execute(new Runnable(){

            @Override
            public void run() {
                Paste paste = new Paste();
                paste.addListener(Console.this.frame);
                paste.setTitle(Console.this.frame.getTitle());
                paste.setContent(U.readFileLog());
                PasteResult result = paste.paste();
                if (result instanceof PasteResult.PasteUploaded) {
                    PasteResult.PasteUploaded uploaded = (PasteResult.PasteUploaded)result;
                    if (Alert.showLocQuestion("console.pastebin.sent", uploaded.getURL())) {
                        OS.openLink(uploaded.getURL());
                    }
                } else if (result instanceof PasteResult.PasteFailed) {
                    Throwable error = ((PasteResult.PasteFailed)result).getError();
                    if (error instanceof RuntimeException) {
                        Alert.showLocError("console.pastebin.invalid", error);
                    } else if (error instanceof IOException) {
                        Alert.showLocError("console.pastebin.failed", error);
                    }
                }
            }
        });
    }

    Point getPositionPoint() {
        this.check();
        return this.frame.getLocation();
    }

    int[] getPosition() {
        this.check();
        Point p = this.getPositionPoint();
        return new int[]{p.x, p.y};
    }

    Dimension getDimension() {
        this.check();
        return this.frame.getSize();
    }

    int[] getSize() {
        this.check();
        Dimension d = this.getDimension();
        return new int[]{d.width, d.height};
    }

    public void updateLocale() {
        this.frame.updateLocale();
    }

    public void setLauncherToKillProcess(MinecraftLauncher launcher) {
        this.launcher = launcher;
        this.frame.bottom.kill.setEnabled(launcher != null);
    }

    public void killProcess() {
        this.launcher.killProcess();
        this.frame.show(true);
    }

    @Override
    public void activateOptions() {
        this.setName("tl console");
        this.setLayout(U.LOG_LAYOUT);
        this.setThreshold(Level.INFO);
        this.setEncoding(TlauncherUtil.LOG_CHARSET);
        this.setWriter(this.createWriter(new OutputStream(){
            ByteArrayOutputStream out = new ByteArrayOutputStream();

            @Override
            public void write(int b) throws IOException {
                char c = (char)b;
                if (c == '\n') {
                    Console.this.frame.println(this.out.toString(TlauncherUtil.LOG_CHARSET));
                    this.out.reset();
                } else {
                    this.out.write(b);
                }
            }
        }));
    }
}

