/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.combobox;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import org.tlauncher.tlauncher.minecraft.auth.Account;
import org.tlauncher.tlauncher.ui.images.ImageCache;
import org.tlauncher.tlauncher.ui.loc.ImageUdaterButton;
import org.tlauncher.tlauncher.ui.loc.Localizable;
import org.tlauncher.tlauncher.ui.login.AccountComboBox;
import org.tlauncher.tlauncher.ui.swing.scroll.VersionScrollBarUI;
import org.tlauncher.tlauncher.ui.ui.CreationModpackComboBoxUI;
import org.tlauncher.util.ColorUtil;

public class LoginComboBoxUI
extends CreationModpackComboBoxUI {
    private static final Icon MANAGE_ICON = ImageCache.getIcon((String)"gear.png");
    private static final Icon MOJANG_USER_ICON = ImageCache.getIcon((String)"mojang-user.png");
    private static final Icon TLAUNCHER_USER_ICON = ImageCache.getIcon((String)"tlauncher-user.png");
    private static final Icon MICROSOFT_USER_ICON = ImageCache.getIcon((String)"microsoft-user.png");
    private static final Icon FREE_USER_ICON = ImageCache.getIcon((String)"free-user.png");
    private final AccountComboBox accountComboBox;

    public LoginComboBoxUI(AccountComboBox accountComboBox) {
        this.accountComboBox = accountComboBox;
        this.setLeftTextGup(31);
    }

    @Override
    public String getText(Object value) {
        Account acc = this.accountComboBox.getAcc();
        Account ac = this.accountComboBox.getAccount();
        if (Objects.isNull(ac)) {
            return "";
        }
        if (acc.equals(AccountComboBox.MANAGE)) {
            return "";
        }
        return ac.getDisplayName();
    }

    @Override
    protected JButton createArrowButton() {
        ImageUdaterButton button = new ImageUdaterButton(Color.WHITE, "black-arrow.png");
        for (ActionListener l : button.getActionListeners()) {
            button.removeActionListener(l);
        }
        button.setModelPressedColor(ColorUtil.COLOR_195);
        return button;
    }

    @Override
    public void paintCurrentValue(Graphics g, Rectangle bounds, boolean hasFocus) {
        super.paintCurrentValue(g, bounds, hasFocus);
        Icon icon = null;
        Account acc = this.accountComboBox.getAcc();
        if (acc == null || acc.equals(AccountComboBox.EMPTY)) {
            this.paintText(g, bounds, Localizable.get("account.empty"));
        } else if (acc.equals(AccountComboBox.MANAGE)) {
            this.paintText(g, bounds, Localizable.get("account.manage"));
            icon = MANAGE_ICON;
            icon.paintIcon(this.accountComboBox, g, 8, 4);
        } else {
            switch (acc.getType()) {
                case TLAUNCHER: {
                    icon = TLAUNCHER_USER_ICON;
                    break;
                }
                case MOJANG: {
                    icon = MOJANG_USER_ICON;
                    break;
                }
                case MICROSOFT: {
                    icon = MICROSOFT_USER_ICON;
                    break;
                }
                case FREE: {
                    icon = FREE_USER_ICON;
                    break;
                }
            }
            if (icon != null) {
                icon.paintIcon(this.accountComboBox, g, 8, 4);
            }
        }
    }

    @Override
    protected ComboPopup createPopup() {
        BasicComboPopup basic = new BasicComboPopup(this.comboBox){
            private static final long serialVersionUID = 1982778991007799667L;

            @Override
            protected JScrollPane createScroller() {
                VersionScrollBarUI barUI = new VersionScrollBarUI(){

                    @Override
                    protected Dimension getMinimumThumbSize() {
                        return new Dimension(13, 40);
                    }

                    @Override
                    public Dimension getMaximumSize(JComponent c) {
                        Dimension dim = super.getMaximumSize(c);
                        dim.setSize(13.0, dim.getHeight());
                        return dim;
                    }

                    @Override
                    public Dimension getPreferredSize(JComponent c) {
                        Dimension dim = super.getPreferredSize(c);
                        dim.setSize(13.0, dim.getHeight());
                        return dim;
                    }
                };
                barUI.setGapThubm(5);
                JScrollPane scroller = new JScrollPane(this.list, 20, 31);
                scroller.setBackground(Color.WHITE);
                scroller.getVerticalScrollBar().setUI(barUI);
                return scroller;
            }
        };
        basic.setBorder(BorderFactory.createMatteBorder(0, 1, 1, 1, Color.WHITE));
        return basic;
    }
}

