/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.button;

import by.gdev.util.DesktopUtil;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.apache.http.client.ClientProtocolException;
import org.tlauncher.modpack.domain.client.GameEntityDTO;
import org.tlauncher.modpack.domain.client.share.GameType;
import org.tlauncher.tlauncher.exceptions.RequiredTLAccountException;
import org.tlauncher.tlauncher.exceptions.SelectedAnyOneTLAccountException;
import org.tlauncher.tlauncher.managers.ModpackManager;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.alert.Alert;
import org.tlauncher.tlauncher.ui.images.ImageCache;
import org.tlauncher.tlauncher.ui.listener.BlockClickListener;
import org.tlauncher.tlauncher.ui.loc.Localizable;

public class StatusStarButton
extends JLabel {
    private static final long serialVersionUID = 8192841246854925487L;
    private volatile boolean status;
    private ModpackManager manager;
    private static final Object OBJECT = new Object();
    private GameEntityDTO entityDTO;

    public StatusStarButton(final GameEntityDTO entityDTO, final GameType type) {
        this.entityDTO = entityDTO;
        this.manager = (ModpackManager)TLauncher.getInjector().getInstance(ModpackManager.class);
        this.updateStatus();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    CompletableFuture.runAsync(() -> DesktopUtil.uncheckCall(() -> {
                        StatusStarButton.this.syncSending(entityDTO, type);
                        return null;
                    }), StatusStarButton.this.manager.getModpackExecutorService()).exceptionally(t -> {
                        SwingUtilities.invokeLater(() -> Alert.showLocError("modpack.internet.update"));
                        return null;
                    });
                }
            }
        });
    }

    public void setStatus(boolean status) {
        this.status = status;
        this.setIcon((Icon)ImageCache.getIcon((String)("star-" + status + ".png")));
    }

    public void updateStatus() {
        this.setStatus(this.manager.getFavoriteGameEntitiesByAccount().contains(this.entityDTO.getId()));
    }

    @Override
    public synchronized void addMouseListener(MouseListener l) {
        if (l instanceof BlockClickListener) {
            return;
        }
        super.addMouseListener(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncSending(GameEntityDTO entityDTO, GameType type) throws ClientProtocolException, IOException, RequiredTLAccountException {
        Object object = OBJECT;
        synchronized (object) {
            try {
                if (this.status) {
                    this.manager.deleteFavoriteGameEntities(entityDTO, type);
                } else {
                    this.manager.addFavoriteGameEntities(entityDTO, type);
                }
                this.setStatus(!this.status);
            }
            catch (RequiredTLAccountException e) {
                Alert.showLocError("modpack.right.panel.required.tl.account.title", Localizable.get("modpack.right.panel.required.tl.account", Localizable.get("loginform.button.settings.account")), null);
            }
            catch (SelectedAnyOneTLAccountException e) {
                Alert.showLocError("modpack.right.panel.required.tl.account.title", "modpack.right.panel.select.account.tl", null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

