/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.repository;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.launcher.Http;
import org.apache.commons.lang3.StringUtils;
import org.tlauncher.util.Time;
import org.tlauncher.util.U;

public class Repo {
    private static final List<String> notShowLogs = new ArrayList<String>(){
        {
            this.add("inner_servers-1.1.json");
        }
    };
    private final String name;
    private final List<String> repos;
    private int primaryTimeout;
    private int selected;
    private boolean isSelected;

    public Repo(String[] urls, String name) {
        if (urls == null) {
            throw new NullPointerException("URL array is NULL!");
        }
        this.name = name;
        this.repos = Collections.synchronizedList(new ArrayList());
        this.primaryTimeout = U.getConnectionTimeout();
        Collections.addAll(this.repos, urls);
    }

    private String getUrl0(String uri) throws IOException {
        boolean canSelect = this.isSelectable();
        if (!canSelect) {
            return this.getRawUrl(uri);
        }
        Object lock = new Object();
        IOException e = null;
        int i = 0;
        int attempt = 0;
        Time.start(lock);
        while (i < 3) {
            int timeout = this.primaryTimeout * ++i;
            for (int x = 0; x < this.getCount(); ++x) {
                ++attempt;
                String url = this.getRepo(x);
                if (notShowLogs.stream().noneMatch(url::endsWith)) {
                    this.log("Attempt #" + attempt + "; timeout: " + timeout + " ms; url: " + url);
                }
                try {
                    String result = Http.performGet(new URL(url + uri), timeout, timeout);
                    if (StringUtils.isEmpty((CharSequence)result)) continue;
                    this.setSelected(x);
                    this.log("Success: Reached the repo in", Time.stop(lock), "ms.");
                    return result;
                }
                catch (IOException e0) {
                    if (notShowLogs.stream().noneMatch(url::endsWith)) {
                        this.log("request to url = " + url + uri);
                    }
                    this.log("Failed: Repo is not reachable!", e0);
                    e = e0;
                }
            }
        }
        Time.stop(lock);
        this.log("Failed: All repos are unreachable.");
        throw (IOException)Objects.requireNonNull(e);
    }

    public String getUrl(String uri) throws IOException {
        return this.getUrl0(uri);
    }

    public String getUrl() throws IOException {
        return this.getUrl0("");
    }

    private String getRawUrl(String uri) throws IOException {
        String url = this.getSelectedRepo() + Http.encode(uri);
        try {
            return Http.performGet(new URL(url));
        }
        catch (IOException e) {
            this.log("Cannot get raw:", url);
            throw e;
        }
    }

    public int getSelected() {
        return this.selected;
    }

    public synchronized void selectNext() {
        if (++this.selected >= this.getCount()) {
            this.selected = 0;
        }
    }

    public String getSelectedRepo() {
        return this.repos.get(this.selected);
    }

    public String getRepo(int pos) {
        return this.repos.get(pos);
    }

    public List<String> getList() {
        return this.repos;
    }

    public int getCount() {
        return this.repos.size();
    }

    boolean isSelected() {
        return this.isSelected;
    }

    void setSelected(int pos) {
        if (!this.isSelectable()) {
            throw new IllegalStateException();
        }
        this.isSelected = true;
        this.selected = pos;
    }

    public boolean isSelectable() {
        return !this.repos.isEmpty();
    }

    public String toString() {
        return this.name;
    }

    private void log(Object ... obj) {
        U.log("[REPO][" + this.name + "]", obj);
    }

    public String getName() {
        return this.name;
    }

    public void reorderedRepoSetFirstProxy() {
        this.repos.sort((e, e1) -> {
            if (e.contains("resource.fastrepo.org/file")) {
                return -1;
            }
            return 0;
        });
    }
}

