/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.modpack;

import com.google.common.collect.Lists;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.launcher.versions.CompleteVersion;
import net.minecraft.launcher.versions.Version;
import org.apache.commons.io.IOUtils;
import org.tlauncher.modpack.domain.client.GameEntityDTO;
import org.tlauncher.modpack.domain.client.GameEntityDependencyDTO;
import org.tlauncher.modpack.domain.client.ModDTO;
import org.tlauncher.modpack.domain.client.ModpackDTO;
import org.tlauncher.modpack.domain.client.share.DependencyType;
import org.tlauncher.modpack.domain.client.share.ForgeStringComparator;
import org.tlauncher.modpack.domain.client.share.GameType;
import org.tlauncher.modpack.domain.client.version.ModpackVersionDTO;
import org.tlauncher.modpack.domain.client.version.VersionDTO;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.loc.Localizable;
import org.tlauncher.util.FileUtil;

public class ModpackUtil {
    public static List<? extends VersionDTO> sortByDate(List<VersionDTO> versions) {
        ArrayList<VersionDTO> sortList = new ArrayList<VersionDTO>(versions);
        sortList.sort((o1, o2) -> o2.getUpdateDate().compareTo(o1.getUpdateDate()));
        return sortList;
    }

    public static Path getPathByVersion(Version version, String ... paths) {
        StringBuilder builder = new StringBuilder();
        builder.append("versions").append("/").append(version.getID());
        for (String line : paths) {
            builder.append("/").append(line);
        }
        return FileUtil.getRelative(builder.toString());
    }

    public static Path getPathByVersion(CompleteVersion version) {
        return ModpackUtil.getPathByVersion(version, "");
    }

    public static String getLatestGameVersion(Set<String> c) {
        if (c.isEmpty()) {
            return null;
        }
        ArrayList list = Lists.newArrayList(c);
        list.sort(new ForgeStringComparator());
        return (String)list.get(0);
    }

    public static void extractIncompatible(GameEntityDTO en, Set<Long> set) {
        if (en.getDependencies() == null) {
            return;
        }
        for (GameEntityDependencyDTO d : en.getDependencies()) {
            if (d.getDependencyType() != DependencyType.INCOMPATIBLE) continue;
            set.add(d.getGameEntityId());
        }
    }

    public static Set<Long> getAllModpackIds(ModpackDTO m) {
        HashSet<Long> set = new HashSet<Long>();
        if (m.getId() != null) {
            set.add(m.getId());
        }
        for (GameType t : GameType.getSubEntities()) {
            List<? extends GameEntityDTO> list = ((ModpackVersionDTO)m.getVersion()).getByType(t);
            for (int i = 0; i < list.size(); ++i) {
                if (!Objects.nonNull(list.get(i).getId())) continue;
                set.add(list.get(i).getId());
            }
        }
        return set;
    }

    public static List<String> getPictureURL(Long id, String type) {
        return Arrays.stream(TLauncher.getInnerSettings().getArray("file.server")).map(s -> s + "/pictures/" + type + "/" + id + ".png").collect(Collectors.toList());
    }

    public static StringBuilder buildMessage(List<GameEntityDTO> list) {
        StringBuilder b = new StringBuilder();
        for (GameEntityDTO dependency : list) {
            b.append(dependency.getName()).append("(").append(Localizable.get("modpack.button." + (Object)((Object)GameType.create(dependency.getClass())))).append(")").append(" ");
        }
        return b;
    }

    public static Path getPath(CompleteVersion v, GameType type) {
        switch (type) {
            case RESOURCEPACK: {
                return ModpackUtil.getPathByVersion(v, "resourcepacks");
            }
            case MOD: {
                return ModpackUtil.getPathByVersion(v, "mods");
            }
            case MAP: {
                return ModpackUtil.getPathByVersion(v, "saves");
            }
            case SHADERPACK: {
                return ModpackUtil.getPathByVersion(v, "shaderpacks");
            }
        }
        throw new RuntimeException("not proper type");
    }

    public static boolean useSkinMod(CompleteVersion version) {
        for (ModDTO m : ((ModpackVersionDTO)version.getModpack().getVersion()).getMods()) {
            if (!ModDTO.TL_SKIN_CAPE_ID.equals(m.getId())) continue;
            return true;
        }
        return false;
    }

    public static void addOrReplaceShaderConfig(CompleteVersion v, String field, String filename) throws IOException {
        Path p = ModpackUtil.getPathByVersion(v).resolve("optionsshaders.txt");
        if (Files.notExists(p, new LinkOption[0])) {
            Files.createFile(p, new FileAttribute[0]);
        }
        Properties properties = new Properties();
        FileInputStream inputStream = new FileInputStream(p.toFile());
        properties.load(new InputStreamReader((InputStream)inputStream, Charset.forName("UTF-8")));
        IOUtils.closeQuietly(inputStream);
        properties.put(field, filename);
        FileWriter fileWriter = new FileWriter(p.toFile());
        properties.store(fileWriter, "");
        IOUtils.closeQuietly(fileWriter);
    }

    public static String readShaderpackConfigField(CompleteVersion v, String name) throws IOException {
        Path p = ModpackUtil.getPathByVersion(v).resolve("optionsshaders.txt");
        Properties properties = new Properties();
        FileInputStream inputStream = new FileInputStream(p.toFile());
        properties.load(new InputStreamReader((InputStream)inputStream, Charset.forName("UTF-8")));
        IOUtils.closeQuietly(inputStream);
        return properties.getProperty(name);
    }
}

