/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.minecraft.launcher;

import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.jagrosh.discordipc.IPCClient;
import com.jagrosh.discordipc.IPCListener;
import com.jagrosh.discordipc.entities.DiscordBuild;
import com.jagrosh.discordipc.entities.RichPresence;
import com.jagrosh.discordipc.entities.pipe.PipeStatus;
import java.time.OffsetDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tlauncher.tlauncher.minecraft.launcher.MinecraftExtendedAdapter;
import org.tlauncher.tlauncher.rmo.DiscordStatus;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.loc.Localizable;

@Singleton
public class MinecraftDiscordAdapter
extends MinecraftExtendedAdapter {
    private static final Logger log = LoggerFactory.getLogger(MinecraftDiscordAdapter.class);
    private IPCClient client = new IPCClient(1140558605771350016L);
    private RichPresence.Builder builder = new RichPresence.Builder();
    private String details;
    private OffsetDateTime startTimestamp;
    private RichPresence richPresence;
    private DiscordStatus discordStatus = DiscordStatus.MAIN;

    @Inject
    public void init() {
        this.client.setListener(new IPCListener(){

            @Override
            public void onReady(IPCClient client) {
                MinecraftDiscordAdapter.this.builder.setDetails(Localizable.get("discord.page.main")).setStartTimestamp(OffsetDateTime.now()).setLargeImage("fav-icon-512");
                MinecraftDiscordAdapter.this.startTimestamp = OffsetDateTime.now();
                client.sendRichPresence(MinecraftDiscordAdapter.this.builder.build());
            }
        });
        try {
            this.client.connect(new DiscordBuild[0]);
        }
        catch (Exception e) {
            log.info("discrord setting status problem: {}", (Object)e.getMessage());
        }
    }

    @Subscribe
    public void handlePurchaseEvent(DiscordStatus event) {
        switch (event) {
            case DOWNLOAD: {
                String loading = Localizable.get("loginform.loading");
                this.details = loading.substring(0, loading.length() - 3) + " " + TLauncher.getInstance().getLauncher().getVersionName();
                break;
            }
            case PLAYING: {
                this.details = Localizable.get("minecraft.playing") + " " + TLauncher.getInstance().getLauncher().getVersionName();
                break;
            }
            case TLMODS: {
                this.discordStatus = event;
                this.details = Localizable.get("discord.page.mods");
                break;
            }
            case MAIN: {
                this.discordStatus = event;
                this.details = Localizable.get("discord.page.main");
            }
        }
        this.createRichPrefence();
    }

    private void createRichPrefence() {
        this.richPresence = new RichPresence(null, this.details, this.startTimestamp, null, "fav-icon-512", null, null, null, null, 0, 0, null, null, null, false);
        if (this.client.getStatus().equals((Object)PipeStatus.CONNECTED)) {
            this.client.sendRichPresence(this.richPresence);
        }
    }

    @Override
    public void onMinecraftClose() {
        this.handlePurchaseEvent(this.getDiscordStatus());
    }

    @Override
    public void onMinecraftLaunch() {
        this.handlePurchaseEvent(DiscordStatus.PLAYING);
    }

    @Override
    public void onMinecraftDownloading() {
        this.handlePurchaseEvent(DiscordStatus.DOWNLOAD);
    }

    public void setDiscordStatus(DiscordStatus discordStatus) {
        this.discordStatus = discordStatus;
    }

    public DiscordStatus getDiscordStatus() {
        return this.discordStatus;
    }
}

