/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.minecraft.auth;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.tlauncher.tlauncher.minecraft.auth.Account;

public class AuthenticatorDatabase {
    private final Map<String, Account> accounts;

    public AuthenticatorDatabase(Map<String, Account> map) {
        if (map == null) {
            throw new NullPointerException();
        }
        this.accounts = map;
    }

    public AuthenticatorDatabase() {
        this(new LinkedHashMap<String, Account>());
    }

    public Collection<Account> getAccounts() {
        return Collections.unmodifiableCollection(this.accounts.values());
    }

    public Account getByUUID(String uuid) {
        for (Account account : this.accounts.values()) {
            if (!StringUtils.equals((CharSequence)account.getUUID(), (CharSequence)uuid)) continue;
            return account;
        }
        return null;
    }

    public Account getByUsername(String username) {
        if (username == null) {
            throw new NullPointerException();
        }
        for (Account acc : this.accounts.values()) {
            if (!username.equals(acc.getUsername())) continue;
            return acc;
        }
        return null;
    }

    public void cleanFreeAccount() {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<String, Account> account : this.accounts.entrySet()) {
            if (!account.getValue().getType().equals((Object)Account.AccountType.FREE)) continue;
            list.add(account.getKey());
        }
        for (String string : list) {
            this.accounts.remove(string);
        }
    }

    public Account getByUsernameType(String username, String type) {
        if (username == null || type == null) {
            throw new NullPointerException();
        }
        for (Account acc : this.accounts.values()) {
            if (!username.equals(acc.getUsername()) || !type.equals(acc.getType().name())) continue;
            return acc;
        }
        return null;
    }

    public static class Serializer
    implements JsonDeserializer<AuthenticatorDatabase>,
    JsonSerializer<AuthenticatorDatabase> {
        @Override
        public AuthenticatorDatabase deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            LinkedHashMap<String, Account> services = new LinkedHashMap<String, Account>();
            Map<String, Map<String, Object>> credentials = this.deserializeCredentials((JsonObject)json, context);
            for (Map.Entry<String, Map<String, Object>> en : credentials.entrySet()) {
                services.put(en.getKey(), new Account(en.getValue()));
            }
            return new AuthenticatorDatabase(services);
        }

        Map<String, Map<String, Object>> deserializeCredentials(JsonObject json, JsonDeserializationContext context) {
            LinkedHashMap<String, Map<String, Object>> result = new LinkedHashMap<String, Map<String, Object>>();
            for (Map.Entry<String, JsonElement> authEntry : json.entrySet()) {
                LinkedHashMap<String, Object> credentials = new LinkedHashMap<String, Object>();
                for (Map.Entry<String, JsonElement> credentialsEntry : ((JsonObject)authEntry.getValue()).entrySet()) {
                    credentials.put(credentialsEntry.getKey(), this.deserializeCredential(credentialsEntry.getValue()));
                }
                result.put(authEntry.getKey(), credentials);
            }
            return result;
        }

        private Object deserializeCredential(JsonElement element) {
            if (element instanceof JsonObject) {
                LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
                for (Map.Entry<String, JsonElement> entry : ((JsonObject)element).entrySet()) {
                    result.put(entry.getKey(), this.deserializeCredential(entry.getValue()));
                }
                return result;
            }
            if (element instanceof JsonArray) {
                ArrayList<Object> result = new ArrayList<Object>();
                for (JsonElement entry : (JsonArray)element) {
                    result.add(this.deserializeCredential(entry));
                }
                return result;
            }
            return element.getAsString();
        }

        @Override
        public JsonElement serialize(AuthenticatorDatabase src, Type typeOfSrc, JsonSerializationContext context) {
            LinkedHashMap credentials = new LinkedHashMap();
            for (Map.Entry en : src.accounts.entrySet()) {
                credentials.put(en.getKey(), ((Account)en.getValue()).createMap());
            }
            return context.serialize(credentials);
        }
    }
}

