/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.managers;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.launcher.versions.CompleteVersion;
import net.minecraft.launcher.versions.Library;
import net.minecraft.launcher.versions.Version;
import net.minecraft.launcher.versions.json.Argument;
import net.minecraft.launcher.versions.json.ArgumentType;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tlauncher.modpack.domain.client.version.MetadataDTO;
import org.tlauncher.tlauncher.component.RefreshableComponent;
import org.tlauncher.tlauncher.entity.TLauncherLib;
import org.tlauncher.tlauncher.entity.TLauncherVersionChanger;
import org.tlauncher.tlauncher.managers.ComponentManager;
import org.tlauncher.tlauncher.minecraft.auth.Account;
import org.tlauncher.tlauncher.minecraft.crash.Crash;
import org.tlauncher.tlauncher.minecraft.launcher.MinecraftException;
import org.tlauncher.tlauncher.minecraft.launcher.MinecraftListener;
import org.tlauncher.tlauncher.modpack.ModpackUtil;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.util.FileUtil;
import org.tlauncher.util.MinecraftUtil;
import org.tlauncher.util.gson.DownloadUtil;

public class TLauncherManager
extends RefreshableComponent
implements MinecraftListener {
    private static final Logger log = LoggerFactory.getLogger(TLauncherManager.class);
    public static final String CLIENT_TL_MANAGER = "_tl_manager";
    private TLauncherVersionChanger tLauncherVersionChanger;
    private final Gson gson = new Gson();

    public TLauncherManager(ComponentManager manager) throws Exception {
        super(manager);
    }

    public boolean useTLauncherAccount(Version version) {
        if (Objects.nonNull(this.tLauncherVersionChanger) && this.tLauncherVersionChanger.getTlauncherSkinCapeVersion().contains(version.getID())) {
            return true;
        }
        return version.isSkinVersion() || version.isActivateSkinCapeForUserVersion();
    }

    private List<TLauncherLib> findAddedLibraries(CompleteVersion complete) {
        String id = this.tLauncherVersionChanger.getVersionIDForUserSkinCapeVersion(complete);
        ArrayList<TLauncherLib> libList = new ArrayList<TLauncherLib>();
        for (TLauncherLib tlauncherLib : this.tLauncherVersionChanger.getLibraries()) {
            if (tlauncherLib.isSupport(id)) {
                libList.add(tlauncherLib);
                continue;
            }
            for (Library library : complete.getLibraries()) {
                if (!tlauncherLib.isApply(library, complete)) continue;
                libList.add(tlauncherLib);
            }
        }
        return libList;
    }

    public boolean applyTLauncherAccountLib(Version original) {
        Account ac = TLauncher.getInstance().getProfileManager().getSelectedAccount();
        if (Objects.nonNull(ac) && Account.AccountType.MOJANG.equals((Object)ac.getSkinType())) {
            return false;
        }
        return this.useTLauncherAccount(original);
    }

    public CompleteVersion addFilesForDownloading(CompleteVersion original, boolean customTexture) {
        if (Objects.isNull(this.tLauncherVersionChanger)) {
            return original;
        }
        this.log("add required libraries:", original.getID());
        CompleteVersion complete = original.fullCopy(new CompleteVersion());
        for (TLauncherLib lib : this.findAddedLibraries(original)) {
            complete.getLibraries().addAll(lib.getRequires());
            complete.getLibraries().add(lib);
            this.addMinecraftClientFiles(complete, lib, CLIENT_TL_MANAGER, false);
        }
        for (TLauncherLib l : this.tLauncherVersionChanger.getAddedMods(complete)) {
            complete.getLibraries().addAll(l.getRequires());
            complete.getLibraries().add(l);
        }
        return complete;
    }

    private void addMinecraftClientFiles(CompleteVersion complete, TLauncherLib lib, String postfix, boolean showLog) {
        if (Objects.nonNull(lib.getDownloads()) && Objects.nonNull(complete.getDownloads())) {
            for (Map.Entry<String, MetadataDTO> e : lib.getDownloads().entrySet()) {
                complete.getDownloads().put(e.getKey() + postfix, e.getValue());
                if (!showLog) continue;
                this.log(String.format("new client will be put: %s", e.getValue().getUrl()));
            }
        }
    }

    @Override
    protected boolean refresh() {
        try {
            this.tLauncherVersionChanger = DownloadUtil.loadObjectByKey("skin.config.library", TLauncherVersionChanger.class);
        }
        catch (Throwable e) {
            this.log("Failed to refresh TLancher manager", e);
            return false;
        }
        return true;
    }

    public CompleteVersion createUpdatedVersion(CompleteVersion original, boolean showLog) {
        CompleteVersion complete = original.fullCopy(new CompleteVersion());
        this.transferVersionArgumentToModern(complete);
        if (Objects.isNull(this.tLauncherVersionChanger)) {
            return complete;
        }
        List<TLauncherLib> libList = this.findAddedLibraries(original);
        boolean tlLibraryType = this.applyTLauncherAccountLib(complete);
        for (TLauncherLib lib : libList) {
            if (!lib.isProperAccountTypeLib(tlLibraryType)) continue;
            boolean added = false;
            List<Library> list = complete.getLibraries();
            for (int i = 0; i < complete.getLibraries().size(); ++i) {
                Library current = complete.getLibraries().get(i);
                if (!lib.isApply(current, complete)) continue;
                if (showLog) {
                    log.info("library will be replaced: {} -> {}", (Object)current.getName(), (Object)lib.getName());
                }
                complete.getLibraries().remove(i);
                complete.getLibraries().add(i, lib);
                added = true;
                this.setAdditionalFields(complete, lib);
                List<Library> requiredLibraries = lib.getRequires();
                this.addedRequiredLibraries(list, requiredLibraries, showLog);
                break;
            }
            if (!added) {
                this.addedRequiredLibraries(complete.getLibraries(), lib.getRequires(), showLog);
                complete.getLibraries().add(0, lib);
                if (showLog) {
                    this.log("library will be added:", lib.getName());
                }
                this.setAdditionalFields(complete, lib);
            }
            this.addMinecraftClientFiles(complete, lib, "", showLog);
        }
        return complete;
    }

    private void transferVersionArgumentToModern(CompleteVersion completeVersion) {
        String s = completeVersion.getMinecraftArguments();
        if (Objects.isNull(s)) {
            return;
        }
        String[] array = s.replace("  ", " ").split(" ");
        ArrayList<Argument> list = new ArrayList<Argument>();
        Arrays.stream(array).forEach(e -> list.add(new Argument(new String[]{e}, null)));
        list.add(new Argument(new String[]{"--width"}, null));
        list.add(new Argument(new String[]{"${resolution_width}"}, null));
        list.add(new Argument(new String[]{"--height"}, null));
        list.add(new Argument(new String[]{"${resolution_height}"}, null));
        HashMap<ArgumentType, List<Argument>> map = new HashMap<ArgumentType, List<Argument>>();
        map.put(ArgumentType.GAME, list);
        ArrayList<Argument> jvm = new ArrayList<Argument>();
        if (Objects.nonNull(completeVersion.getJVMArguments())) {
            array = completeVersion.getJVMArguments().replace("  ", " ").split(" ");
            Arrays.stream(array).forEach(e -> jvm.add(new Argument(new String[]{e}, null)));
        }
        jvm.add(new Argument(new String[]{"-Djava.library.path=${natives_directory}"}, null));
        jvm.add(new Argument(new String[]{"-cp"}, null));
        jvm.add(new Argument(new String[]{"${classpath}"}, null));
        map.put(ArgumentType.JVM, jvm);
        completeVersion.setArguments(map);
    }

    private void addedRequiredLibraries(List<Library> list, List<Library> requiredLibraries, boolean showLog) {
        if (Objects.isNull(requiredLibraries)) {
            return;
        }
        for (Library r : requiredLibraries) {
            boolean addedRequiredLib = false;
            for (int j = 0; j < list.size(); ++j) {
                Library l = list.get(j);
                if (!r.getPlainName().equals(l.getPlainName())) continue;
                if (showLog) {
                    this.log("library will be replaced as required:", r.getName());
                }
                list.remove(j);
                list.add(j, r);
                addedRequiredLib = true;
                break;
            }
            if (addedRequiredLib) continue;
            list.add(0, r);
            if (!showLog) continue;
            this.log("library will be added as required:", r.getName());
        }
    }

    private void setAdditionalFields(CompleteVersion complete, TLauncherLib lib) {
        Map<ArgumentType, List<Argument>> arguments = lib.getArguments();
        if (Objects.nonNull(arguments)) {
            for (Map.Entry<ArgumentType, List<Argument>> arg : arguments.entrySet()) {
                ArgumentType type = arg.getKey();
                List<Argument> libArguments = arg.getValue();
                List<Argument> versionArguments = complete.getArguments().get((Object)type);
                for (Argument a : libArguments) {
                    boolean added = false;
                    for (int i = 0; i < versionArguments.size(); ++i) {
                        if (!Arrays.equals(a.getValues(), versionArguments.get(i).getValues())) continue;
                        versionArguments.remove(i);
                        versionArguments.add(i, a);
                        added = true;
                        break;
                    }
                    if (added) continue;
                    versionArguments.add(a);
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)lib.getMainClass())) {
            complete.setMainClass(lib.getMainClass());
        }
    }

    @Override
    public void onMinecraftPrepare() {
        this.cleanMods();
    }

    @Override
    public void onMinecraftAbort() {
    }

    @Override
    public void onMinecraftLaunch() {
        List<Library> libraries;
        File optifineTempFile = new File(MinecraftUtil.getWorkingDirectory(), TLauncher.getInnerSettings().get("skin.config.temp.optifine.file.new"));
        Path mods = Paths.get(MinecraftUtil.getWorkingDirectory().getAbsolutePath(), "mods");
        CompleteVersion completeVersion = TLauncher.getInstance().getLauncher().getVersion();
        if (completeVersion.isModpack()) {
            mods = ModpackUtil.getPathByVersion(completeVersion, "mods");
        }
        if (!Files.exists(mods, new LinkOption[0])) {
            try {
                Files.createDirectory(mods, new FileAttribute[0]);
            }
            catch (IOException e1) {
                this.log(e1);
            }
        }
        List<String> filesMods = this.readMods();
        if (completeVersion.getID().startsWith("ForgeOptiFine")) {
            for (Library library : completeVersion.getLibraries()) {
                if (!library.getName().contains("optifine:OptiFine")) continue;
                Path out = this.copyMods(library);
                filesMods.add(out.toString());
                break;
            }
        }
        if (completeVersion.getModsLibraries() != null) {
            libraries = completeVersion.getModsLibraries();
            this.copyListMods(filesMods, libraries);
        }
        if (Objects.nonNull(this.tLauncherVersionChanger)) {
            libraries = this.tLauncherVersionChanger.getAddedMods(completeVersion, this.applyTLauncherAccountLib(completeVersion));
            this.copyListMods(filesMods, libraries);
        }
        try {
            String result = this.gson.toJson(filesMods, new TypeToken<ArrayList<String>>(){}.getType());
            FileUtil.writeFile(optifineTempFile, result);
        }
        catch (IOException e) {
            this.log(e);
        }
        this.printModsFiles("mods after", mods);
    }

    private void copyListMods(List<String> filesMods, List<? extends Library> libraries) {
        for (Library library : libraries) {
            filesMods.add(this.copyMods(library).toString());
        }
    }

    private Path copyMods(Library library) {
        Path in = Paths.get(MinecraftUtil.getWorkingDirectory().getAbsolutePath(), "libraries", library.getArtifactPath());
        Path out = Paths.get(MinecraftUtil.getWorkingDirectory().getAbsolutePath(), "mods", FilenameUtils.getName(library.getArtifactPath()));
        try {
            Files.copy(in, out, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            this.log(e);
        }
        return out;
    }

    @Override
    public void onMinecraftClose() {
    }

    @Override
    public void onMinecraftError(Throwable e) {
    }

    @Override
    public void onMinecraftKnownError(MinecraftException e) {
    }

    @Override
    public void onMinecraftCrash(Crash crash) {
    }

    public void cleanMods() {
        Path mods1 = Paths.get(MinecraftUtil.getWorkingDirectory().getAbsolutePath(), "mods");
        this.printModsFiles("before clearLibrary", mods1);
        Path old = FileUtil.getRelativeConfig("skin.config.temp.optifine.file");
        Path mods = FileUtil.getRelativeConfig("skin.config.temp.optifine.file.new");
        if (Files.exists(old, new LinkOption[0])) {
            try {
                this.log("clear old library");
                Files.delete(Paths.get(FileUtil.readFile(old.toFile()), new String[0]));
                Files.delete(old);
            }
            catch (IOException exception) {
                this.log(exception);
            }
            catch (InvalidPathException ex) {
                try {
                    Files.delete(old);
                }
                catch (IOException e) {
                    this.log(e);
                }
            }
        }
        this.cleanMods(mods);
        this.printModsFiles("after clearLibrary", mods1);
    }

    private void cleanMods(Path mods) {
        if (Files.exists(mods, new LinkOption[0])) {
            List<String> list = this.readMods();
            if (!list.isEmpty()) {
                Iterator<String> it = list.iterator();
                while (it.hasNext()) {
                    String file = it.next();
                    try {
                        Files.delete(Paths.get(file, new String[0]));
                        it.remove();
                    }
                    catch (InvalidPathException | NoSuchFileException e) {
                        it.remove();
                        this.log(e);
                    }
                    catch (IOException exception) {
                        this.log(exception.getMessage());
                    }
                }
            }
            this.writeStateMod(list);
        }
    }

    private void writeStateMod(List<String> list) {
        try {
            String result = this.gson.toJson(list, new TypeToken<ArrayList<String>>(){}.getType());
            FileUtil.writeFile(FileUtil.getRelativeConfigFile("skin.config.temp.optifine.file.new"), result);
            this.log("written: ", result);
        }
        catch (IOException e) {
            this.log(e);
        }
    }

    private void printModsFiles(String state, Path mods) {
        File[] files = mods.toFile().listFiles(File::isFile);
        if (Objects.nonNull(files)) {
            this.log(state, files);
        }
    }

    private List<String> readMods() {
        Path mods = FileUtil.getRelativeConfig("skin.config.temp.optifine.file.new");
        List list = null;
        if (Files.exists(mods, new LinkOption[0])) {
            try {
                list = (List)this.gson.fromJson(FileUtil.readFile(mods.toFile(), "utf-8"), new TypeToken<ArrayList<String>>(){}.getType());
            }
            catch (JsonSyntaxException | IOException e) {
                this.log(e);
            }
        }
        return list == null ? new ArrayList() : list;
    }
}

