/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.downloader;

import java.util.Objects;
import org.tlauncher.modpack.domain.client.version.MetadataDTO;
import org.tlauncher.tlauncher.downloader.Downloadable;
import org.tlauncher.tlauncher.downloader.DownloadableContainer;
import org.tlauncher.tlauncher.downloader.DownloadableContainerHandlerAdapter;
import org.tlauncher.tlauncher.downloader.RetryDownloadException;
import org.tlauncher.util.FileUtil;

public class DefaultDownloadableContainerHandler
extends DownloadableContainerHandlerAdapter {
    @Override
    public void onComplete(DownloadableContainer c, Downloadable d) throws RetryDownloadException {
        MetadataDTO m = d.getMetadataDTO();
        if (m.getSha1() == null) {
            return;
        }
        String hash = FileUtil.getChecksum(m.getLocalDestination());
        if (Objects.isNull(hash) || hash.equals(m.getSha1())) {
            return;
        }
        throw new RetryDownloadException(String.format("illegal hash, got: %s; expected: %s", hash, m.getSha1()));
    }
}

