/*
 * Decompiled with CFR 0.152.
 */
package by.gdev.util;

import by.gdev.util.CheckedFunction;
import by.gdev.util.OSInfo;
import by.gdev.util.model.download.Metadata;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.PosixFilePermission;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.JFileChooser;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DesktopUtil {
    private static final Logger log = LoggerFactory.getLogger(DesktopUtil.class);
    private static final String PROTECTION = "protection.txt";
    private static FileLock lock;
    public static Set<PosixFilePermission> PERMISSIONS;

    public static File getSystemPath(OSInfo.OSType type, String path) {
        File file;
        String userHome = System.getProperty("user.home", ".");
        switch (type) {
            case LINUX: 
            case SOLARIS: {
                file = new File(userHome, path);
                break;
            }
            case WINDOWS: {
                String applicationData = System.getenv("APPDATA");
                String folder = applicationData != null ? applicationData : userHome;
                file = new File(folder, path);
                break;
            }
            case MACOSX: {
                file = new File(userHome, "Library/Application Support/" + path);
                break;
            }
            default: {
                file = new File(userHome, path);
            }
        }
        return file;
    }

    public static String getChecksum(byte[] array, String algorithm) throws IOException, NoSuchAlgorithmException {
        return DesktopUtil.createChecksum(array, algorithm);
    }

    public static String getChecksum(File file, String algorithm) throws IOException, NoSuchAlgorithmException {
        return DesktopUtil.createChecksum(Files.readAllBytes(file.toPath()), algorithm);
    }

    private static String createChecksum(byte[] array, String algorithm) throws NoSuchAlgorithmException {
        MessageDigest complete = MessageDigest.getInstance(algorithm);
        complete.update(array);
        byte[] b = complete.digest();
        StringBuilder result = new StringBuilder();
        for (byte cb : b) {
            result.append(Integer.toString((cb & 0xFF) + 256, 16).substring(1));
        }
        return result.toString();
    }

    public static String getJavaPathByHome(boolean appendBinFolder) {
        String path = System.getProperty("java.home");
        if (appendBinFolder) {
            path = DesktopUtil.appendToJVM(path);
        }
        return path;
    }

    public static String appendToJVM(String path) {
        char separator = File.separatorChar;
        StringBuilder b = new StringBuilder(path);
        b.append(separator);
        b.append("bin").append(separator).append("java");
        if (OSInfo.getOSType().equals((Object)OSInfo.OSType.WINDOWS)) {
            b.append("w.exe");
        }
        return b.toString();
    }

    public static <T> T uncheckCall(Callable<T> callable) {
        try {
            return callable.call();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T, R> Function<T, R> wrap(CheckedFunction<T, R> checkedFunction) {
        return t -> {
            try {
                return checkedFunction.apply(t);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static void sleep(int milliSeconds) {
        try {
            Thread.sleep(milliSeconds);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static int numberOfAttempts(List<String> urls, int maxAttepmts, RequestConfig requestConfig, CloseableHttpClient httpclient) {
        int attempt = 1;
        for (String url : urls) {
            try {
                HttpHead http = new HttpHead(url);
                http.setConfig(requestConfig);
                httpclient.execute(http);
                return maxAttepmts;
            }
            catch (IOException iOException) {
            }
        }
        return attempt;
    }

    private static void createDirectory(File file) throws IOException {
        if (file.isFile()) {
            return;
        }
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
    }

    public static void diactivateDoubleDownloadingResourcesLock() throws IOException {
        if (Objects.nonNull(lock)) {
            lock.release();
        }
    }

    public static String convertListToString(String del, List<Path> list) {
        StringBuilder b = new StringBuilder();
        for (Path string : list) {
            b.append(string).append(del);
        }
        return b.toString();
    }

    public static void activeDoubleDownloadingResourcesLock(String container) throws IOException {
        FileChannel ch;
        File f = new File(container, PROTECTION);
        DesktopUtil.createDirectory(f);
        if (f.exists() && Objects.isNull(lock = (ch = FileChannel.open(f.toPath(), StandardOpenOption.WRITE, StandardOpenOption.CREATE)).tryLock())) {
            log.warn("Lock could not be acquired ");
            System.exit(4);
        }
    }

    public static Path getJavaRun(Path java) throws IOException {
        return Files.walk(java, new FileVisitOption[0]).filter(e -> Files.isRegularFile(e, new LinkOption[0]) && (e.endsWith("java") || e.endsWith("java.exe"))).findAny().orElseThrow(() -> new RuntimeException("java executable not found "));
    }

    public static String appendBootstrapperJvm2(String path) {
        StringBuilder b = new StringBuilder();
        if (OSInfo.getOSType() == OSInfo.OSType.MACOSX) {
            b.append("Contents").append(File.separatorChar).append("Home").append(File.separatorChar);
        }
        return DesktopUtil.appendToJVM(new File(b.toString()).getPath());
    }

    public static void openLink(OSInfo.OSType type, String uri) {
        block4: {
            try {
                Desktop.getDesktop().browse(new URI(uri));
            }
            catch (IOException | URISyntaxException e) {
                log.warn("can't open link", e);
                if (!type.equals((Object)OSInfo.OSType.LINUX)) break block4;
                try {
                    Runtime.getRuntime().exec("gnome-open " + uri);
                }
                catch (IOException e1) {
                    log.warn("can't open link for linix", e);
                }
            }
        }
    }

    public static void initLookAndFeel() {
        block4: {
            LookAndFeel defaultLookAndFeel = null;
            try {
                defaultLookAndFeel = UIManager.getLookAndFeel();
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                new JFileChooser();
            }
            catch (Throwable t) {
                log.warn("problem with ", t);
                if (!Objects.nonNull(defaultLookAndFeel)) break block4;
                try {
                    UIManager.setLookAndFeel(defaultLookAndFeel);
                }
                catch (Throwable e) {
                    log.warn("coudn't set defualt look and feel", e);
                }
            }
        }
    }

    public static List<String> generatePath(List<String> repositories, List<Metadata> resources) {
        return repositories.stream().map(repo -> resources.stream().map(res -> String.format("%s/%s", repo, res.getRelativeUrl())).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toList());
    }

    static {
        PERMISSIONS = new HashSet<PosixFilePermission>(){
            {
                this.add(PosixFilePermission.OWNER_READ);
                this.add(PosixFilePermission.OWNER_WRITE);
                this.add(PosixFilePermission.OWNER_EXECUTE);
                this.add(PosixFilePermission.OTHERS_READ);
                this.add(PosixFilePermission.OTHERS_WRITE);
                this.add(PosixFilePermission.OTHERS_EXECUTE);
                this.add(PosixFilePermission.GROUP_READ);
                this.add(PosixFilePermission.GROUP_WRITE);
                this.add(PosixFilePermission.GROUP_EXECUTE);
            }
        };
    }
}

