/*
 * Decompiled with CFR 0.152.
 */
package by.gdev.http.download.impl;

import by.gdev.http.download.exeption.StatusExeption;
import by.gdev.http.download.impl.DownloadRunnableImpl;
import by.gdev.http.download.service.Downloader;
import by.gdev.http.upload.download.downloader.DownloadElement;
import by.gdev.http.upload.download.downloader.DownloaderContainer;
import by.gdev.http.upload.download.downloader.DownloaderStatus;
import by.gdev.http.upload.download.downloader.DownloaderStatusEnum;
import by.gdev.util.model.download.Metadata;
import com.google.common.eventbus.EventBus;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloaderImpl
implements Downloader {
    private static final Logger log = LoggerFactory.getLogger(DownloaderImpl.class);
    private String pathToDownload;
    private EventBus eventBus;
    private CloseableHttpClient httpclient;
    private RequestConfig requestConfig;
    private Queue<DownloadElement> downloadElements = new ConcurrentLinkedQueue<DownloadElement>();
    private List<DownloadElement> processedElements = Collections.synchronizedList(new ArrayList());
    private List<Long> allConteinerSize = new ArrayList<Long>();
    private volatile DownloaderStatusEnum status;
    private DownloadRunnableImpl runnable;
    private volatile Integer allCountElement;
    private long fullDownloadSize;
    private long downloadBytesNow;
    private LocalTime start;
    private long sizeDownloadNow;

    public DownloaderImpl(EventBus eventBus, CloseableHttpClient httpclient, RequestConfig requestConfig) {
        this.eventBus = eventBus;
        this.httpclient = httpclient;
        this.requestConfig = requestConfig;
        this.status = DownloaderStatusEnum.IDLE;
        this.runnable = new DownloadRunnableImpl(this.downloadElements, this.processedElements, httpclient, requestConfig, eventBus);
    }

    @Override
    public void addContainer(DownloaderContainer container) {
        if (Objects.nonNull(container.getRepo().getResources())) {
            container.getRepo().getResources().forEach(metadata -> {
                DownloadElement element = new DownloadElement();
                element.setMetadata((Metadata)metadata);
                element.setRepo(container.getRepo());
                element.setPathToDownload(container.getDestinationRepositories());
                element.setHandlers(container.getHandlers());
                this.downloadElements.add(element);
            });
        }
        this.pathToDownload = container.getDestinationRepositories();
        this.allConteinerSize.add(container.getContainerSize());
    }

    @Override
    public void startDownload(boolean sync) throws InterruptedException, ExecutionException, StatusExeption, IOException {
        this.fullDownloadSize = this.allConteinerSize.stream().reduce(Long::sum).orElse(0L);
        this.sizeDownloadNow = this.sizeDownload();
        this.start = LocalTime.now();
        if (this.status.equals((Object)DownloaderStatusEnum.IDLE)) {
            this.status = DownloaderStatusEnum.WORK;
            this.runnable.setStatus(this.status);
            this.allCountElement = this.downloadElements.size();
            ArrayList<CompletableFuture<Void>> listThread = new ArrayList<CompletableFuture<Void>>();
            for (int i = 0; i < 3; ++i) {
                listThread.add(CompletableFuture.runAsync(this.runnable));
            }
            if (sync) {
                this.waitThreadDone(listThread);
            } else {
                CompletableFuture.runAsync(() -> {
                    try {
                        this.waitThreadDone(listThread);
                    }
                    catch (InterruptedException e) {
                        log.error("Error", e);
                    }
                }).get();
            }
        } else {
            throw new StatusExeption(this.status.toString());
        }
    }

    @Override
    public void cancelDownload() {
        this.status = DownloaderStatusEnum.CANCEL;
        this.runnable.setStatus(DownloaderStatusEnum.CANCEL);
    }

    private DownloaderStatus buildDownloaderStatus() {
        DownloaderStatus statusDownload = new DownloaderStatus();
        long downloadBytesNow = 0L;
        ArrayList<DownloadElement> list = new ArrayList<DownloadElement>(this.processedElements);
        ArrayList<Throwable> errorList = new ArrayList<Throwable>();
        double thirty = Duration.between(this.start, LocalTime.now()).getSeconds();
        for (DownloadElement elem : list) {
            downloadBytesNow += elem.getDownloadBytes();
            if (!Objects.nonNull(elem.getError())) continue;
            errorList.add(elem.getError());
        }
        statusDownload.setThrowables(errorList);
        statusDownload.setDownloadSize(this.sizeDownloadNow + downloadBytesNow);
        statusDownload.setSpeed((double)(downloadBytesNow / 0x100000L) / thirty);
        statusDownload.setDownloaderStatusEnum(this.status);
        statusDownload.setAllDownloadSize(this.fullDownloadSize);
        statusDownload.setLeftFiles(this.processedElements.size());
        statusDownload.setAllFiles(this.allCountElement);
        return statusDownload;
    }

    private void waitThreadDone(List<CompletableFuture<Void>> listThread) throws InterruptedException {
        LocalTime start = LocalTime.now();
        boolean workedAnyThread = true;
        while (workedAnyThread) {
            workedAnyThread = false;
            Thread.sleep(50L);
            workedAnyThread = listThread.stream().anyMatch(e -> !e.isDone());
            if (!start.isBefore(LocalTime.now())) continue;
            start = start.plusSeconds(1L);
            if (this.allCountElement == 0 || start.getSecond() == start.plusSeconds(1L).getSecond()) continue;
            this.eventBus.post((Object)this.buildDownloaderStatus());
        }
        this.status = DownloaderStatusEnum.DONE;
        this.eventBus.post((Object)this.buildDownloaderStatus());
    }

    private long sizeDownload() throws IOException {
        return Files.walk(Paths.get(this.pathToDownload, new String[0]), new FileVisitOption[0]).filter(p -> !p.toString().contains("jre_default") || p.endsWith(".json")).filter(p -> p.toFile().isFile()).mapToLong(p -> p.toFile().length()).sum();
    }

    public String getPathToDownload() {
        return this.pathToDownload;
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }

    public CloseableHttpClient getHttpclient() {
        return this.httpclient;
    }

    public RequestConfig getRequestConfig() {
        return this.requestConfig;
    }

    public Queue<DownloadElement> getDownloadElements() {
        return this.downloadElements;
    }

    public List<DownloadElement> getProcessedElements() {
        return this.processedElements;
    }

    public List<Long> getAllConteinerSize() {
        return this.allConteinerSize;
    }

    public DownloaderStatusEnum getStatus() {
        return this.status;
    }

    public DownloadRunnableImpl getRunnable() {
        return this.runnable;
    }

    public Integer getAllCountElement() {
        return this.allCountElement;
    }

    public long getFullDownloadSize() {
        return this.fullDownloadSize;
    }

    public long getDownloadBytesNow() {
        return this.downloadBytesNow;
    }

    public LocalTime getStart() {
        return this.start;
    }

    public long getSizeDownloadNow() {
        return this.sizeDownloadNow;
    }

    public void setPathToDownload(String pathToDownload) {
        this.pathToDownload = pathToDownload;
    }

    public void setEventBus(EventBus eventBus) {
        this.eventBus = eventBus;
    }

    public void setHttpclient(CloseableHttpClient httpclient) {
        this.httpclient = httpclient;
    }

    public void setRequestConfig(RequestConfig requestConfig) {
        this.requestConfig = requestConfig;
    }

    public void setDownloadElements(Queue<DownloadElement> downloadElements) {
        this.downloadElements = downloadElements;
    }

    public void setProcessedElements(List<DownloadElement> processedElements) {
        this.processedElements = processedElements;
    }

    public void setAllConteinerSize(List<Long> allConteinerSize) {
        this.allConteinerSize = allConteinerSize;
    }

    public void setStatus(DownloaderStatusEnum status) {
        this.status = status;
    }

    public void setRunnable(DownloadRunnableImpl runnable) {
        this.runnable = runnable;
    }

    public void setAllCountElement(Integer allCountElement) {
        this.allCountElement = allCountElement;
    }

    public void setFullDownloadSize(long fullDownloadSize) {
        this.fullDownloadSize = fullDownloadSize;
    }

    public void setDownloadBytesNow(long downloadBytesNow) {
        this.downloadBytesNow = downloadBytesNow;
    }

    public void setStart(LocalTime start) {
        this.start = start;
    }

    public void setSizeDownloadNow(long sizeDownloadNow) {
        this.sizeDownloadNow = sizeDownloadNow;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DownloaderImpl)) {
            return false;
        }
        DownloaderImpl other = (DownloaderImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$pathToDownload = this.getPathToDownload();
        String other$pathToDownload = other.getPathToDownload();
        if (this$pathToDownload == null ? other$pathToDownload != null : !this$pathToDownload.equals(other$pathToDownload)) {
            return false;
        }
        EventBus this$eventBus = this.getEventBus();
        EventBus other$eventBus = other.getEventBus();
        if (this$eventBus == null ? other$eventBus != null : !this$eventBus.equals(other$eventBus)) {
            return false;
        }
        CloseableHttpClient this$httpclient = this.getHttpclient();
        CloseableHttpClient other$httpclient = other.getHttpclient();
        if (this$httpclient == null ? other$httpclient != null : !this$httpclient.equals(other$httpclient)) {
            return false;
        }
        RequestConfig this$requestConfig = this.getRequestConfig();
        RequestConfig other$requestConfig = other.getRequestConfig();
        if (this$requestConfig == null ? other$requestConfig != null : !this$requestConfig.equals(other$requestConfig)) {
            return false;
        }
        Queue<DownloadElement> this$downloadElements = this.getDownloadElements();
        Queue<DownloadElement> other$downloadElements = other.getDownloadElements();
        if (this$downloadElements == null ? other$downloadElements != null : !this$downloadElements.equals(other$downloadElements)) {
            return false;
        }
        List<DownloadElement> this$processedElements = this.getProcessedElements();
        List<DownloadElement> other$processedElements = other.getProcessedElements();
        if (this$processedElements == null ? other$processedElements != null : !((Object)this$processedElements).equals(other$processedElements)) {
            return false;
        }
        List<Long> this$allConteinerSize = this.getAllConteinerSize();
        List<Long> other$allConteinerSize = other.getAllConteinerSize();
        if (this$allConteinerSize == null ? other$allConteinerSize != null : !((Object)this$allConteinerSize).equals(other$allConteinerSize)) {
            return false;
        }
        DownloaderStatusEnum this$status = this.getStatus();
        DownloaderStatusEnum other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        DownloadRunnableImpl this$runnable = this.getRunnable();
        DownloadRunnableImpl other$runnable = other.getRunnable();
        if (this$runnable == null ? other$runnable != null : !((Object)this$runnable).equals(other$runnable)) {
            return false;
        }
        Integer this$allCountElement = this.getAllCountElement();
        Integer other$allCountElement = other.getAllCountElement();
        if (this$allCountElement == null ? other$allCountElement != null : !((Object)this$allCountElement).equals(other$allCountElement)) {
            return false;
        }
        if (this.getFullDownloadSize() != other.getFullDownloadSize()) {
            return false;
        }
        if (this.getDownloadBytesNow() != other.getDownloadBytesNow()) {
            return false;
        }
        LocalTime this$start = this.getStart();
        LocalTime other$start = other.getStart();
        if (this$start == null ? other$start != null : !((Object)this$start).equals(other$start)) {
            return false;
        }
        return this.getSizeDownloadNow() == other.getSizeDownloadNow();
    }

    protected boolean canEqual(Object other) {
        return other instanceof DownloaderImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $pathToDownload = this.getPathToDownload();
        result = result * 59 + ($pathToDownload == null ? 43 : $pathToDownload.hashCode());
        EventBus $eventBus = this.getEventBus();
        result = result * 59 + ($eventBus == null ? 43 : $eventBus.hashCode());
        CloseableHttpClient $httpclient = this.getHttpclient();
        result = result * 59 + ($httpclient == null ? 43 : $httpclient.hashCode());
        RequestConfig $requestConfig = this.getRequestConfig();
        result = result * 59 + ($requestConfig == null ? 43 : $requestConfig.hashCode());
        Queue<DownloadElement> $downloadElements = this.getDownloadElements();
        result = result * 59 + ($downloadElements == null ? 43 : $downloadElements.hashCode());
        List<DownloadElement> $processedElements = this.getProcessedElements();
        result = result * 59 + ($processedElements == null ? 43 : ((Object)$processedElements).hashCode());
        List<Long> $allConteinerSize = this.getAllConteinerSize();
        result = result * 59 + ($allConteinerSize == null ? 43 : ((Object)$allConteinerSize).hashCode());
        DownloaderStatusEnum $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        DownloadRunnableImpl $runnable = this.getRunnable();
        result = result * 59 + ($runnable == null ? 43 : ((Object)$runnable).hashCode());
        Integer $allCountElement = this.getAllCountElement();
        result = result * 59 + ($allCountElement == null ? 43 : ((Object)$allCountElement).hashCode());
        long $fullDownloadSize = this.getFullDownloadSize();
        result = result * 59 + (int)($fullDownloadSize >>> 32 ^ $fullDownloadSize);
        long $downloadBytesNow = this.getDownloadBytesNow();
        result = result * 59 + (int)($downloadBytesNow >>> 32 ^ $downloadBytesNow);
        LocalTime $start = this.getStart();
        result = result * 59 + ($start == null ? 43 : ((Object)$start).hashCode());
        long $sizeDownloadNow = this.getSizeDownloadNow();
        result = result * 59 + (int)($sizeDownloadNow >>> 32 ^ $sizeDownloadNow);
        return result;
    }

    public String toString() {
        return "DownloaderImpl(pathToDownload=" + this.getPathToDownload() + ", eventBus=" + this.getEventBus() + ", httpclient=" + this.getHttpclient() + ", requestConfig=" + this.getRequestConfig() + ", downloadElements=" + this.getDownloadElements() + ", processedElements=" + this.getProcessedElements() + ", allConteinerSize=" + this.getAllConteinerSize() + ", status=" + (Object)((Object)this.getStatus()) + ", runnable=" + this.getRunnable() + ", allCountElement=" + this.getAllCountElement() + ", fullDownloadSize=" + this.getFullDownloadSize() + ", downloadBytesNow=" + this.getDownloadBytesNow() + ", start=" + this.getStart() + ", sizeDownloadNow=" + this.getSizeDownloadNow() + ")";
    }

    public DownloaderImpl(String pathToDownload, EventBus eventBus, CloseableHttpClient httpclient, RequestConfig requestConfig, Queue<DownloadElement> downloadElements, List<DownloadElement> processedElements, List<Long> allConteinerSize, DownloaderStatusEnum status, DownloadRunnableImpl runnable, Integer allCountElement, long fullDownloadSize, long downloadBytesNow, LocalTime start, long sizeDownloadNow) {
        this.pathToDownload = pathToDownload;
        this.eventBus = eventBus;
        this.httpclient = httpclient;
        this.requestConfig = requestConfig;
        this.downloadElements = downloadElements;
        this.processedElements = processedElements;
        this.allConteinerSize = allConteinerSize;
        this.status = status;
        this.runnable = runnable;
        this.allCountElement = allCountElement;
        this.fullDownloadSize = fullDownloadSize;
        this.downloadBytesNow = downloadBytesNow;
        this.start = start;
        this.sizeDownloadNow = sizeDownloadNow;
    }
}

