/*
 * Decompiled with CFR 0.152.
 */
package by.gdev.http.download.handler;

import by.gdev.http.download.exeption.HashSumAndSizeError;
import by.gdev.http.download.handler.PostHandler;
import by.gdev.http.download.model.Headers;
import by.gdev.http.upload.download.downloader.DownloadElement;
import by.gdev.util.DesktopUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostHandlerImpl
implements PostHandler {
    private static final Logger log = LoggerFactory.getLogger(PostHandlerImpl.class);

    @Override
    public void postProcessDownloadElement(DownloadElement element) {
        try {
            Path localeFile = Paths.get(element.getPathToDownload(), element.getMetadata().getPath());
            String shaLocalFile = DesktopUtil.getChecksum(localeFile.toFile(), Headers.SHA1.getValue());
            long sizeLocalFile = localeFile.toFile().length();
            if (sizeLocalFile != element.getMetadata().getSize() && StringUtils.isEmpty((CharSequence)element.getMetadata().getLink())) {
                element.setError(new HashSumAndSizeError(element.getMetadata().getRelativeUrl(), element.getPathToDownload() + element.getMetadata().getPath(), "The size should be " + element.getMetadata().getSize()));
                this.removeFile(localeFile);
            }
            if (!shaLocalFile.equals(element.getMetadata().getSha1()) && StringUtils.isEmpty((CharSequence)element.getMetadata().getLink())) {
                element.setError(new HashSumAndSizeError(element.getRepo().getRepositories().get(0) + element.getMetadata().getRelativeUrl(), element.getPathToDownload() + element.getMetadata().getPath(), "The hash sum should be " + element.getMetadata().getSha1()));
                this.removeFile(localeFile);
            }
        }
        catch (IOException | NoSuchAlgorithmException e) {
            log.error("Erorr", e);
        }
    }

    private void removeFile(Path localeFile) {
        try {
            Files.delete(localeFile.toAbsolutePath());
        }
        catch (IOException e) {
            log.error("file can't be deleted {}", (Object)e.getMessage());
        }
    }
}

